package com.bcxin.ins.dao.preservation;

import com.bcxin.ins.entity.policy_core.InsPreservationResultSet;
import com.bcxin.ins.spring.annotation.MyBatisDao;
import com.bcxin.ins.vo.InsPreservationDetailVo;
import com.bcxin.ins.vo.InsPreservationResultSetVo;
import com.bcxin.ins.vo.excel.InsPerExcelVo;
import com.bcxin.ins.vo.excel.ResultSetExcelVo;
import com.bcxin.mybatisplus.mapper.BaseMapper;
import com.bcxin.mybatisplus.plugins.Page;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;


/**
 * <b>保全版本有效被保险人集合表</b>
 */
@MyBatisDao
public interface InsPreservationResultSetAPIDao extends BaseMapper<InsPreservationResultSet> {


    public List<InsPreservationResultSet> findInsPreservationResultSetByKeyword(Page<InsPreservationResultSet> page
            , @Param("preservationId") Long preservationId
            , @Param("keyword") String keyword
            , @Param("status") String status
            , @Param("start_time") String start_time
            , @Param("end_time") String end_time);

    public List<InsPreservationResultSet> findInsPreservationResultSetByKeyword(@Param("preservationId") Long preservationId
            , @Param("keyword") String keyword
            , @Param("status") String status
            , @Param("start_time") String start_time
            , @Param("end_time") String end_time);

    /* start 以下查询，根据订单id查询结果集 */
    public List<InsPreservationResultSet> findResultSetByKeyword(Page<InsPreservationResultSet> page
            , @Param("order_id") Long order_id
            , @Param("keyword") String keyword
            , @Param("status") String status
            , @Param("start_time") String start_time
            , @Param("end_time") String end_time);

    public List<InsPreservationResultSet> findResultSetByKeyword(@Param("order_id") Long order_id
            , @Param("keyword") String keyword
            , @Param("status") String status
            , @Param("start_time") String start_time
            , @Param("end_time") String end_time);

    public List<InsPreservationResultSet> findZBByPolicyId(@Param("order_id") Long order_id,@Param("productCode") String productCode);
    public List<InsPreservationDetailVo> findInsPreservationDetailVoByIdCards(@Param("order_id") Long order_id
            , @Param("list") String[] list);
    public List<InsPreservationDetailVo> findInsPreservationDetailVoByImportBatchId(@Param("order_id") Long order_id
            , @Param("importBatchId") String importBatchId);
    public Integer findZBNumber(@Param("dqNum") int dqNum, @Param("order_id") Long order_id);
    /* end */

    int batchUpdateStatus(@Param("id") Long[] id, @Param("status") int status, @Param("type") String type, @Param("date") String date);
    InsPreservationResultSet getResultSetBypolicyIdAndCardNo(@Param("orderId") Long orderId, @Param("idCard") String idCard);
    Long getResultSetIdByRecord(@Param("orderId") Long orderId, @Param("idCard") String idCard);
    String getBusinessInceptionDateByBusinessId(@Param("businessId") String businessId);

    void batchInsert(@Param("list") List<InsPreservationResultSet> list);

    String findDuplicateIdCardNo(@Param("day") String day, @Param("name_cn") String name_cn, @Param("code") String code, @Param("list") String[] list);

    String findNotUnderWarrantyIdCardNo(@Param("orderId") String orderId, @Param("list") String[] list);

    List<Map> sassFindPerNameByIdCard(@Param("list") String[] list);

    Map<String,Integer> countCareer(@Param("list") String[] list);

    Map<String,String> getCostByOrderId(@Param("lastDay") int lastDay,@Param("recordCount") int recordCount,@Param("orderId") Long orderId);

    List<ResultSetExcelVo> queryResultSetVo(Long oid);

    InsPreservationResultSetVo setResultSetVo(Long result_id);

    List<InsPreservationResultSetVo> setResultSetVoList(@Param("order_id") Long order_id, @Param("list") List<String> list);

    /**
     * <b> 根据批次id查询错误的条目 做导出 </b>
     * @author ZXF
     * @create 2020/01/16 0016 11:31
     * @version
     * @注意事项 </b>
     */
    List<InsPerExcelVo> findErrTempBatchInsPerImport(@Param("importBatchId") Long importBatchId);


    /**
     * <b> 删除批次id对应的所有记录 </b>
     * @author ZXF
     * @create 2020/01/16 0016 14:28
     * @version
     * @注意事项 </b>
     */
    int deleteTempBatchInsPerImport(@Param("importBatchId") Long importBatchId);
    /**
     * <b> excel导入的有效行更新到临时表 </b>
     * @author ZXF
     * @create 2020/01/16 0016 14:19
     * @version
     * @注意事项 </b>
     */
    int saveTempBatchInsPerImport(@Param("list") List<Map<String, Object>> list, @Param("importBatchId") Long importBatchId);

    /**
     * <b> 校验导入的人员是否存在身份证重复 </b>
     * @author ZXF
     * @create 2020/01/16 0016 16:01
     * @version
     * @注意事项 </b>
     */
    int checkIdCardNoRepeat(@Param("importBatchId") Long importBatchId);

    /**
     * <b> 临时表中人员在该企业的所有保单中是否在保 </b>
     * @author ZXF
     * @create 2020/06/04 0004 16:15
     * @version
     * @注意事项 </b>
     */
    int checkIsZb(@Param("importBatchId") Long importBatchId);

    /**
     * <b> 根据批次Id统计错误信息行数 </b>
     * @author ZXF
     * @create 2020/01/16 0016 14:32
     * @version
     * @注意事项 </b>
     */
    int countErrOrSuccessTempBatchInsPerImport(@Param("isSuccess") String isSuccess, @Param("importBatchId") Long importBatchId);
    /**
     * <b> 根据批次Id和企业Id查询该批次人员对应的保单信息(对应批量导入减员功能返回的有效结果集) </b>
     * @author ZXF
     * @create 2020/06/04 0004 17:19
     * @version
     * @注意事项 </b>
     */
    List<Map<String,String>> findValidMinusInsByImportBatchId(@Param("importBatchId") Long importBatchId);
}
