package com.bcxin.ins.dao.order;

import com.bcxin.ins.entity.policy_core.InsInsuranceSlip;
import com.bcxin.ins.spring.annotation.MyBatisDao;
import com.bcxin.ins.vo.InsOrderSearchVo;
import com.bcxin.ins.vo.OrderFormDetailsVo;
import com.bcxin.ins.vo.OrderFormVo;
import com.bcxin.ins.vo.OrderStatusCountVo;
import com.bcxin.mybatisplus.mapper.BaseMapper;
import com.bcxin.mybatisplus.plugins.Page;
import org.apache.ibatis.annotations.Param;

import java.util.List;
import java.util.Map;


/**
 * <b>投保单主表数据访问 </b>
 * 
 * @author zxf
 * @date 2017年1月5日 上午10:43:31
 * @注意事项 </b>
 * <b>
 */
@MyBatisDao
public interface InsInsuranceSlipAPIDao extends BaseMapper<InsInsuranceSlip> {

	public InsInsuranceSlip selectById(@Param("id") Long id);

	InsInsuranceSlip selectByTradeSerialNumber(@Param("tradeSerialNumber") String tradeSerialNumber);

	/**
	 * <b>根据前台用户id跟订单状态查询订单并进行分页 </b>
	 *
	 * @param userId
	 * @param status
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午8:21:24
	 * @注意事项 </b>
	 * <b>
	 */
	List<InsInsuranceSlip> selectInsOrderFormByUserIDAndStatus(Page<InsInsuranceSlip> page, @Param("userId") Long userId, @Param("status") String status);

	/**
	 * <b>根据前台用户id跟订单状态列表查询订单并进行分页 </b>
	 *
	 * @param userId
	 * @param statusList
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午8:21:24
	 * @注意事项 </b>
	 * <b>
	 */
	List<InsInsuranceSlip> selectInsOrderFormByUserIDAndStatusList(Page<InsInsuranceSlip> pageHelper, @Param("userId") Long userId, @Param("statusList") List<String> statusList);

	/**
	 * <b>根据前台用户id查找对应订单所有状态的总条目 </b>
	 *
	 * @param
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午9:59:47
	 * @注意事项 </b>
	 * <b>
	 */
	OrderStatusCountVo selectOrderStatusCountVoByUserID(InsOrderSearchVo searchVo);

	Map selectOrderByExAndName(@Param("external_reference") String external_reference, @Param("name") String name);

	/**
	 * <b>查询所有订单</b>
	 *
	 * @param sql
	 * @return
	 * @author liyongqiang
	 * @date 2017年1月12日 上午9:53:46
	 * @注意事项 </b>
	 * <b>
	 */
	List<InsInsuranceSlip> findAllInsOrderList(String sql);



	/**
	 * <b>查询所有订单 </b>
	 *
	 * @param
	 * @return
	 * @author liyongqiang
	 * @date 2017年2月9日 下午1:32:57
	 * @注意事项 </b>
	 * <b>
	 */
	List<OrderFormVo> findInsOrderForm(InsInsuranceSlip insOrderForm);


	List<OrderFormVo> getLawsuitList();


	/**
	 * 通过订单Id查询诉讼详情---用于核保
	 * @param id
	 * @return
	 */
	OrderFormDetailsVo selectByInsOrderFormVo(Long id);

	/**
	 * <b>根据投保单号查询订单Vo </b>
	 *
	 * @param rcptNo
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午9:59:47
	 * @注意事项 </b>
	 * <b>
	 */
	public OrderFormVo getOrderFormVoByRcptNo(@Param("rcptNo") String rcptNo);

	public OrderFormVo getOrderFormVoByTradeSerialNumber( @Param("tsNumber") String tsNumber);

	public OrderFormVo getOrderFormVoByNoticeNo( @Param("noticeNo") String noticeNo);

	/**
	 * <b>根据订单id查找对应OrderFormVo信息 </b>
	 *
	 * @param id
	 * @param userId
	 * @param statusList
	 * @param status
	 * @return
	 * @author ZXF
	 * @date 2017年1月9日 下午9:59:47
	 * @注意事项 </b>
	 * <b>
	 */
	List<OrderFormVo> findOrderFormVoByID(
			@Param("id") Long id
			, @Param("userId") Long userId
			, @Param("statusList") List<String> statusList
			, @Param("pType") String pType
			, @Param("status") String status
			, @Param("keyword") String keyword
			, @Param("starDate") String starDate
			, @Param("endDate") String endDate
			, @Param("businessType") String businessType);

	OrderFormVo getOrderFormVoByID(@Param("order_id") Long order_id);

	List<OrderFormVo> listOrderFormVoByDzbdIsNot(@Param("productCode") String productCode);

	public List<OrderFormVo> selectInsOrderFormByStatusAndProductCode( @Param("status") String status, @Param("productCode") String productCode);

	/****************************/

	public List<OrderFormVo> findOrderFormVoByID(
			Page<OrderFormVo> page
			, @Param("id") Long id
			, @Param("userId") Long userId
			, @Param("statusList") List<String> statusList
			, @Param("pType") String pType
			, @Param("status") String status
			, @Param("keyword") String keyword
			, @Param("starDate") String starDate
			, @Param("endDate") String endDate
			, @Param("businessType") String businessType);

	public OrderFormVo findPolicyByExternalAndRoleName(@Param("externalRefernce") String externalRefernce);

	/**
	 * <b> 是否传输影像字段修改 </b>
	 * @author ZXF
	 * @create 2018/04/28 0028 13:59
	 * @version
	 * @注意事项 </b>
	 */
	public int updateIsSendYX(@Param("is_send_yx") int is_send_yx, @Param("order_id") Long order_id);

	/**
	 * <b> 设置是否见费 </b>
	 * @author ZXF
	 * @create 2020/04/10 0010 10:53
	 * @version
	 * @注意事项 </b>
	 */
	public int updateIsPolicyBeforePayFee(@Param("is_policy_before_pay_fee") int is_policy_before_pay_fee, @Param("order_id") Long order_id);

	public int addRemarksByOrder(@Param("remarks")String remarks, @Param("order_id")Long order_id);

	public String getProductCode(@Param("order_id") Long order_id);

	/**
	 * <b> 根据产品标识查询已承保但未有保全结果集记录的订单id(目前产品标识仅限团意险和雇主责任险需要做保全) </b>
	 * @param product_code TYX,GZZRX
	 * @author ZXF
	 * @create 2018/06/05 0005 13:25
	 * @version
	 * @注意事项 </b>
	 */
	public List<String> selectOrderIdByProductCode(@Param("product_code") String product_code);

	/**
	 * <b> 查询将到期保单，第一个日期参数必传 </b>
	 * @author ZXF
	 * @create 2019/04/01 0001 13:51
	 * @version
	 * @注意事项 </b>
	 */
	List<Map<String,Object>> findMaturingPolicy(@Param("aDay")String aDay, @Param("bDay")String bDay, @Param("cDay")String cDay);

	List<Map<String,String>> findZBNumByPolicyNos(@Param("list")String[] list);

	/**
	 * <b> 查询平安财雇主的保单号列 </b>
	 * @author ZXF
	 * @create 2020/04/27 0027 11:21
	 * @version
	 * @注意事项 </b>
	 */
	List<String> findPolicyNosByPACGZZRX(@Param("userId")Long userId);
	List<String> findPolicyNosByCAGZZRX(@Param("userId")Long userId);

	Long getIdByPolicyNo(@Param("policyNo")String policyNo);

	/**
	 * <b> 根据身份证查询有过参与投保的保单记录 </b>
	 * @author ZXF
	 * @create 2020/06/29 0029 17:55
	 * @version
	 * @注意事项 </b>
	 */
	List<Map<String,Object>> findPolicyByIdCard(@Param("idCardNo")String idCardNo);

	/**
	 * <b> 根据产品Id组装保障责任内容json串 </b>
	 * @author ZXF
	 * @create 2020/07/03 0003 15:59
	 * @version
	 * @注意事项 </b>
	 */
	String getBZContentJsonByProductId(@Param("productId")String productId);

	/**
	 * <b> 根据产品Id组装条款Json串 </b>
	 * @author ZXF
	 * @create 2020/07/03 0003 15:59
	 * @version
	 * @注意事项 </b>
	 */
	String getClausesJsonByProductId(@Param("productId")String productId);

	/**
	 * <b> 做批单时，检索生效时间是否是到期时间当天 </b>
	 * @author ZXF
	 * @create 2020/09/07 0007 9:50
	 * @version
	 * @注意事项 </b>
	 */
	int isDueToByPolicy(@Param("orderId")Long orderId, @Param("inception_date")String inception_date);

	/**
	 * <b> 根据保单号获取回溯记录 </b>
	 * @author ZXF
	 * @create 2024/03/04 0004 10:01
	 * @version
	 * @注意事项 </b>
	 */
	List<Map<String,String>> findOperationRecordByExNo(@Param("exNo") String exNo);

	int saveInsOperationRecord(@Param("id")Long id, @Param("order_id")String order_id, @Param("sig_id")String sig_id, @Param("operation_type")String operation_type, @Param("path")String path);
	int updateOrderIdBySigId(@Param("order_id")String order_id, @Param("sig_id")String sig_id);
	int updateWebTypeByEx(@Param("policyNo")String policyNo, @Param("webType")String webType);
}
