/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.storage;

import com.pingan.iobs.sdk.common.Config;
import com.pingan.iobs.sdk.common.IOBSException;
import com.pingan.iobs.sdk.http.Client;
import com.pingan.iobs.sdk.model.Response;
import com.pingan.iobs.sdk.util.StringMap;
import com.pingan.iobs.sdk.util.StringUtils;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStream;

public class FormUploader {
    private String SERVICE_PATH = "/upload";
    private Client client;
    private String token;
    private String bucket;
    private String key;
    private File file;
    private String mime;
    private String persistentOps;
    private String persistentNotifyUrl;
    private InputStream ins;
    private String fileName;
    private long length;

    public FormUploader(Client client, String token, String bucket, File file, String persistentOps, String persistentNotifyUrl) {
        this.client = client;
        this.token = token;
        this.bucket = bucket;
        this.file = file;
        this.persistentNotifyUrl = persistentNotifyUrl;
        this.persistentOps = persistentOps;
    }

    public FormUploader(Client client, String token, String bucket, String key, File file, String persistentOps, String persistentNotifyUrl) {
        this.client = client;
        this.token = token;
        this.bucket = bucket;
        this.key = key;
        this.file = file;
        this.persistentNotifyUrl = persistentNotifyUrl;
        this.persistentOps = persistentOps;
    }

    public FormUploader(Client client, String token, String bucket, InputStream ins, String fileName, long length, String persistentOps, String persistentNotifyUrl) {
        this.client = client;
        this.token = token;
        this.bucket = bucket;
        this.ins = ins;
        this.fileName = fileName;
        this.length = length;
        this.persistentOps = persistentOps;
        this.persistentNotifyUrl = persistentNotifyUrl;
    }

    public FormUploader(Client client, String token, String bucket, String key, InputStream ins, String fileName, long length, String persistentOps, String persistentNotifyUrl) {
        this.client = client;
        this.token = token;
        this.bucket = bucket;
        this.key = key;
        this.ins = ins;
        this.fileName = fileName;
        this.length = length;
        this.persistentOps = persistentOps;
        this.persistentNotifyUrl = persistentNotifyUrl;
    }

    public Response upload() throws IOBSException {
        String url = this.buildUrl();
        StringMap params = this.buildParams();
        return this.client.post(url, this.file, params);
    }

    private StringMap buildParams() {
        StringMap params = new StringMap();
        params.putNotEmpty("token", this.token);
        params.putNotEmpty("persistentOps", this.persistentOps);
        params.putNotEmpty("persistentNotifyUrl", this.persistentNotifyUrl);
        return params;
    }

    private String buildUrl() {
        StringBuffer sb = new StringBuffer();
        sb.append(Config.HOST).append(this.SERVICE_PATH).append("/").append(this.bucket);
        if (!StringUtils.isNullOrEmpty(this.key)) {
            sb.append("/").append(this.key);
        }
        return sb.toString();
    }

    public Response uploadStream() throws IOBSException {
        String url = this.buildUrl();
        StringMap params = this.buildParams();
        long l = this.length = this.length <= 0L ? this.getLength(this.ins) : this.length;
        if (this.length <= 0L) {
            return this.toUploadFile(url, this.ins, this.fileName, params);
        }
        return this.client.post(url, this.ins, this.fileName, this.length, params);
    }

    private Response toUploadFile(String url, InputStream ins, String fileName, StringMap params) throws IOBSException {
        File tempFile = null;
        try {
            tempFile = this.copyToTempFile(ins, fileName);
            Response response = this.client.post(url, tempFile, params);
            return response;
        }
        catch (IOException e) {
            throw new IOBSException(e);
        }
        finally {
            if (tempFile != null) {
                tempFile.delete();
            }
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private File copyToTempFile(InputStream ins, String fileName) throws IOException {
        FileOutputStream fous = null;
        try {
            int leng;
            File tempFile = File.createTempFile("iobs", fileName);
            fous = new FileOutputStream(tempFile);
            byte[] bytes = new byte[65536];
            while ((leng = ins.read(bytes)) != -1) {
                fous.write(bytes, 0, leng);
            }
            fous.flush();
            File file = tempFile;
            return file;
        }
        finally {
            if (ins != null) {
                ins.close();
            }
            if (fous != null) {
                fous.close();
            }
        }
    }

    private long getLength(InputStream ins) {
        try {
            return ins.available();
        }
        catch (IOException e) {
            return -1L;
        }
    }
}

