/*
 * Decompiled with CFR 0.152.
 */
package com.pingan.iobs.sdk.repkg.org.apache.http.impl.client;

import com.pingan.iobs.sdk.repkg.org.apache.http.HttpHost;
import com.pingan.iobs.sdk.repkg.org.apache.http.annotation.NotThreadSafe;
import com.pingan.iobs.sdk.repkg.org.apache.http.auth.AuthScheme;
import com.pingan.iobs.sdk.repkg.org.apache.http.client.AuthCache;
import com.pingan.iobs.sdk.repkg.org.apache.http.conn.SchemePortResolver;
import com.pingan.iobs.sdk.repkg.org.apache.http.conn.UnsupportedSchemeException;
import com.pingan.iobs.sdk.repkg.org.apache.http.impl.conn.DefaultSchemePortResolver;
import com.pingan.iobs.sdk.repkg.org.apache.http.util.Args;
import java.util.HashMap;

@NotThreadSafe
public class BasicAuthCache
implements AuthCache {
    private final HashMap<HttpHost, AuthScheme> map = new HashMap();
    private final SchemePortResolver schemePortResolver;

    public BasicAuthCache(SchemePortResolver schemePortResolver) {
        this.schemePortResolver = schemePortResolver != null ? schemePortResolver : DefaultSchemePortResolver.INSTANCE;
    }

    public BasicAuthCache() {
        this(null);
    }

    protected HttpHost getKey(HttpHost host) {
        if (host.getPort() <= 0) {
            int port;
            try {
                port = this.schemePortResolver.resolve(host);
            }
            catch (UnsupportedSchemeException ignore) {
                return host;
            }
            return new HttpHost(host.getHostName(), port, host.getSchemeName());
        }
        return host;
    }

    @Override
    public void put(HttpHost host, AuthScheme authScheme) {
        Args.notNull(host, "HTTP host");
        this.map.put(this.getKey(host), authScheme);
    }

    @Override
    public AuthScheme get(HttpHost host) {
        Args.notNull(host, "HTTP host");
        return this.map.get(this.getKey(host));
    }

    @Override
    public void remove(HttpHost host) {
        Args.notNull(host, "HTTP host");
        this.map.remove(this.getKey(host));
    }

    @Override
    public void clear() {
        this.map.clear();
    }

    public String toString() {
        return this.map.toString();
    }
}

