package com.bcxin.identify.components;

import java.util.Collection;
import java.util.Map;
import java.util.function.Supplier;

public interface HotCacheProvider {
    <T> T get(String key, Supplier<T> supplier, long cacheInSeconds, Class<T> tClass, boolean enableLocalCache);

    <T> T get(String key, Class<T> tClass);

    <T> void put(String key, long cacheInSeconds, T data, boolean enableLocalCache);

    void delete(String key);

    void delete(Collection<String> keys);

    boolean hasKey(String key);
}


