package com.bcxin.identify.api.lieying.controller;

import cn.hutool.core.date.DateUtil;
import cn.hutool.core.util.RandomUtil;
import cn.hutool.core.util.StrUtil;
import com.bcxin.identify.api.baidu.service.BaiduVerifaceService;
import com.bcxin.identify.business.service.LYTrajectoryService;
import com.bcxin.identify.util.Result;
import com.bcxin.identify.util.baidu.BaiduFaceCutUtil;
import com.bcxin.identify.util.codes.CommonConst;
import com.bcxin.identify.util.common.StringUtil;
import com.bcxin.identify.util.sys.ConfigUtil;
import com.google.common.collect.Maps;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;
import org.springframework.web.multipart.MultipartFile;

import javax.annotation.Resource;
import javax.servlet.http.HttpServletRequest;
import java.io.File;
import java.util.HashMap;
import java.util.Map;

/**
 * <b> 猎鹰轨迹服务、设备相关信息服务接口 </b>
 * @author ZXF
 * @create 2021/01/28 0028 13:20
 * @version
 * @注意事项 </b>
 */
@Controller
@RequestMapping("/identify/api/trajectory")
@Slf4j
public class TrajectoryController {

    @Resource
    private LYTrajectoryService lYTrajectoryService;

    /**
     * <b> 新增key记录自动创建15个service </b>
     * @author ZXF
     * @create 2021/01/29 0029 13:41
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/create-key-and-service")
    @ResponseBody
    public Result createKeyAndService(HttpServletRequest request) {
        String key = request.getParameter("key");
        String province = request.getParameter("province");
//        String token = request.getParameter("token");
//        log.debug("接口【/identify/api/baidu/match-face】token:"+token);
//        Claims claims;
//        try {
//            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
//        } catch (Exception e) {
//            return Result.fail("秘钥不对，解密失败");
//        }
//        String subject = claims.getSubject();
//        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });
        Map<String,String> params = Maps.newHashMap();
        params.put("key",key);
        params.put("province",province);

        if (StrUtil.isEmpty(params.get("key"))
                ||StrUtil.isEmpty(params.get("province"))
                ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/baidu/create-key-and-service】新增key记录自动创建15个service开始。");
        Result result = lYTrajectoryService.createKeyAndService(new HashMap<>(params));
        log.debug("接口【/identify/api/baidu/create-key-and-service】新增key记录自动创建15个service结束。");
        return result;
    }

    /**
     * <b> 根据省编码查询可用的key/sid </b>
     * @author ZXF
     * @create 2021/01/29 0029 13:41
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/get-key-by-province")
    @ResponseBody
    public Result getKeyByProvince(HttpServletRequest request) {
        String province = request.getParameter("province");
//        String token = request.getParameter("token");
//        log.debug("接口【/identify/api/baidu/match-face】token:"+token);
//        Claims claims;
//        try {
//            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
//        } catch (Exception e) {
//            return Result.fail("秘钥不对，解密失败");
//        }
//        String subject = claims.getSubject();
//        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });
        Map<String,String> params = Maps.newHashMap();
        params.put("province",province);

        if (StrUtil.isEmpty(params.get("province"))
                ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/baidu/get-key-by-province】根据省编码查询可用的key/sid开始。");
        Result result = lYTrajectoryService.getKeyByProvince(new HashMap<>(params));
        log.debug("接口【/identify/api/baidu/get-key-by-province】根据省编码查询可用的key/sid结束。");
        return result;
    }

    /**
     * <b> 根据userid查询key、sid、tid </b>
     * @author ZXF
     * @create 2021/01/29 0029 13:41
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/get-terminal-by-user-id")
    @ResponseBody
    public Result getTerminalByUserId(HttpServletRequest request) {
        String userid = request.getParameter("userid");
//        String token = request.getParameter("token");
//        log.debug("接口【/identify/api/baidu/match-face】token:"+token);
//        Claims claims;
//        try {
//            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
//        } catch (Exception e) {
//            return Result.fail("秘钥不对，解密失败");
//        }
//        String subject = claims.getSubject();
//        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });
        Map<String,String> params = Maps.newHashMap();
        params.put("userid",userid);

        if (StrUtil.isEmpty(params.get("userid"))
                ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/baidu/get-terminal-by-user-id】根据userid查询key、sid、tid开始。");
        Result result = lYTrajectoryService.getTerminalByUserId(new HashMap<>(params));
        log.debug("接口【/identify/api/baidu/get-terminal-by-user-id】根据userid查询key、sid、tid结束。");
        return result;
    }

    /**
     * <b> 根据sid、userid、tid新增设备关系记录 </b>
     * @author ZXF
     * @create 2021/01/29 0029 13:41
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/create-terminal")
    @ResponseBody
    public Result createTerminal(HttpServletRequest request) {
        String sid = request.getParameter("sid");
        String userid = request.getParameter("userid");
        String tid = request.getParameter("tid");
//        String token = request.getParameter("token");
//        log.debug("接口【/identify/api/baidu/match-face】token:"+token);
//        Claims claims;
//        try {
//            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
//        } catch (Exception e) {
//            return Result.fail("秘钥不对，解密失败");
//        }
//        String subject = claims.getSubject();
//        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });
        Map<String,String> params = Maps.newHashMap();
        params.put("sid",sid);
        params.put("userid",userid);
        params.put("tid",tid);

        if (StrUtil.isEmpty(params.get("sid"))
                ||StrUtil.isEmpty(params.get("userid"))
                ||StrUtil.isEmpty(params.get("tid"))
                ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/baidu/create-terminal】根据sid、userid、tid新增设备关系记录开始。");
        Result result = lYTrajectoryService.createTerminal(new HashMap<>(params));
        log.debug("接口【/identify/api/baidu/create-terminal】根据sid、userid、tid新增设备关系记录结束。");
        return result;
    }

    /**
     * <b> 查询轨迹信息 </b>
     * @author ZXF
     * @create 2021/01/29 0029 13:41
     * @version
     * @注意事项 </b>
     */
    @RequestMapping("/track-trsearch")
    @ResponseBody
    public Result trackTrsearch(HttpServletRequest request) {
        String key = request.getParameter("key");
        String sid = request.getParameter("sid");
        String tid = request.getParameter("tid");
        String trid  = request.getParameter("trid ");
        String day = request.getParameter("day");
//        String token = request.getParameter("token");
//        log.debug("接口【/identify/api/baidu/match-face】token:"+token);
//        Claims claims;
//        try {
//            claims = JwtUtil.parseJWT(token, ConfigUtil.getValue("JWT_SECRET"));
//        } catch (Exception e) {
//            return Result.fail("秘钥不对，解密失败");
//        }
//        String subject = claims.getSubject();
//        Map<String,String> params = JSON.parseObject(subject, new TypeReference<Map>(){ });
        Map<String,String> params = Maps.newHashMap();
        params.put("sid",sid);
        params.put("key",key);
        params.put("tid",tid);
        params.put("trid",trid);
        params.put("day",day);

        if (StrUtil.isEmpty(params.get("sid"))
                ||StrUtil.isEmpty(params.get("key"))
                ||StrUtil.isEmpty(params.get("tid"))
                ||StrUtil.isEmpty(params.get("day"))
        ) {
            return Result.fail("参数不完整");
        }
        log.debug("接口【/identify/api/baidu/create-terminal】查询轨迹信息开始。");
        Result result = lYTrajectoryService.trackTrsearch(new HashMap<>(params));
        log.debug("接口【/identify/api/baidu/create-terminal】查询轨迹信息结束。");
        return result;
    }
}
