'use strict';

Object.defineProperty(exports, '__esModule', { value: true });

var jsQR = require('jsqr');

function _interopDefaultLegacy (e) { return e && typeof e === 'object' && 'default' in e ? e : { 'default': e }; }

var jsQR__default = /*#__PURE__*/_interopDefaultLegacy(jsQR);

/*! *****************************************************************************
Copyright (c) Microsoft Corporation. All rights reserved.
Licensed under the Apache License, Version 2.0 (the "License"); you may not use
this file except in compliance with the License. You may obtain a copy of the
License at http://www.apache.org/licenses/LICENSE-2.0

THIS CODE IS PROVIDED ON AN *AS IS* BASIS, WITHOUT WARRANTIES OR CONDITIONS OF ANY
KIND, EITHER EXPRESS OR IMPLIED, INCLUDING WITHOUT LIMITATION ANY IMPLIED
WARRANTIES OR CONDITIONS OF TITLE, FITNESS FOR A PARTICULAR PURPOSE,
MERCHANTABLITY OR NON-INFRINGEMENT.

See the Apache Version 2.0 License for specific language governing permissions
and limitations under the License.
***************************************************************************** */

var __assign = function() {
    __assign = Object.assign || function __assign(t) {
        for (var s, i = 1, n = arguments.length; i < n; i++) {
            s = arguments[i];
            for (var p in s) if (Object.prototype.hasOwnProperty.call(s, p)) t[p] = s[p];
        }
        return t;
    };
    return __assign.apply(this, arguments);
};

function __awaiter(thisArg, _arguments, P, generator) {
    return new (P || (P = Promise))(function (resolve, reject) {
        function fulfilled(value) { try { step(generator.next(value)); } catch (e) { reject(e); } }
        function rejected(value) { try { step(generator["throw"](value)); } catch (e) { reject(e); } }
        function step(result) { result.done ? resolve(result.value) : new P(function (resolve) { resolve(result.value); }).then(fulfilled, rejected); }
        step((generator = generator.apply(thisArg, _arguments || [])).next());
    });
}

function __generator(thisArg, body) {
    var _ = { label: 0, sent: function() { if (t[0] & 1) throw t[1]; return t[1]; }, trys: [], ops: [] }, f, y, t, g;
    return g = { next: verb(0), "throw": verb(1), "return": verb(2) }, typeof Symbol === "function" && (g[Symbol.iterator] = function() { return this; }), g;
    function verb(n) { return function (v) { return step([n, v]); }; }
    function step(op) {
        if (f) throw new TypeError("Generator is already executing.");
        while (_) try {
            if (f = 1, y && (t = op[0] & 2 ? y["return"] : op[0] ? y["throw"] || ((t = y["return"]) && t.call(y), 0) : y.next) && !(t = t.call(y, op[1])).done) return t;
            if (y = 0, t) op = [op[0] & 2, t.value];
            switch (op[0]) {
                case 0: case 1: t = op; break;
                case 4: _.label++; return { value: op[1], done: false };
                case 5: _.label++; y = op[1]; op = [0]; continue;
                case 7: op = _.ops.pop(); _.trys.pop(); continue;
                default:
                    if (!(t = _.trys, t = t.length > 0 && t[t.length - 1]) && (op[0] === 6 || op[0] === 2)) { _ = 0; continue; }
                    if (op[0] === 3 && (!t || (op[1] > t[0] && op[1] < t[3]))) { _.label = op[1]; break; }
                    if (op[0] === 6 && _.label < t[1]) { _.label = t[1]; t = op; break; }
                    if (t && _.label < t[2]) { _.label = t[2]; _.ops.push(op); break; }
                    if (t[2]) _.ops.pop();
                    _.trys.pop(); continue;
            }
            op = body.call(thisArg, _);
        } catch (e) { op = [6, e]; y = 0; } finally { f = t = 0; }
        if (op[0] & 5) throw op[1]; return { value: op[0] ? op[1] : void 0, done: true };
    }
}

var videoSize = {
    width: { min: 360, ideal: 720, max: 1080 },
    height: { min: 360, ideal: 720, max: 1080 },
};
var QrcodeDecoder = /** @class */ (function () {
    function QrcodeDecoder() {
        this.timerCapture = null;
        this.canvasElem = null;
        this.gCtx = null;
        this.stream = null;
        this.videoElem = null;
        this.getUserMediaHandler = null;
        this.videoConstraints = {
            // default use rear camera
            video: __assign(__assign({}, videoSize), { facingMode: { exact: 'environment' } }),
            audio: false,
        };
        this.defaultOption = { inversionAttempts: 'attemptBoth' };
    }
    /**
     * Verifies if canvas element is supported.
     */
    QrcodeDecoder.prototype.isCanvasSupported = function () {
        var elem = document.createElement('canvas');
        return !!(elem.getContext && elem.getContext('2d'));
    };
    QrcodeDecoder.prototype._createImageData = function (target, width, height) {
        if (!this.canvasElem) {
            this._prepareCanvas(width, height);
        }
        this.gCtx.clearRect(0, 0, width, height);
        this.gCtx.drawImage(target, 0, 0, width, height);
        var imageData = this.gCtx.getImageData(0, 0, this.canvasElem.width, this.canvasElem.height);
        return imageData;
    };
    /**
     * Prepares the canvas element (which will
     * receive the image from the camera and provide
     * what the algorithm needs for checking for a
     * QRCode and then decoding it.)
     *
     *
     * @param  {DOMElement} canvasElem the canvas
     *                                 element
     * @param  {number} width      The width that
     *                             the canvas element
     *                             should have
     * @param  {number} height     The height that
     *                             the canvas element
     *                             should have
     * @return {DOMElement}            the canvas
     * after the resize if width and height
     * provided.
     */
    QrcodeDecoder.prototype._prepareCanvas = function (width, height) {
        if (!this.canvasElem) {
            this.canvasElem = document.createElement('canvas');
            this.canvasElem.style.width = "".concat(width, "px");
            this.canvasElem.style.height = "".concat(height, "px");
            this.canvasElem.width = width;
            this.canvasElem.height = height;
        }
        this.gCtx = this.canvasElem.getContext('2d');
    };
    /**
     * Based on the video dimensions and the canvas
     * that was previously generated captures the
     * video/image source and then paints into the
     * canvas so that the decoder is able to work as
     * it expects.
     * @param  {DOMElement} videoElem <video> dom element
     * @param  {Object} options     options (optional) - Additional options.
     *  inversionAttempts - (attemptBoth (default), dontInvert, onlyInvert, or invertFirst)
     *  refer to jsqr options: https://github.com/cozmo/jsQR
     */
    QrcodeDecoder.prototype._captureToCanvas = function (videoElem, options) {
        return __awaiter(this, void 0, void 0, function () {
            var proms, result;
            var _this = this;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (this.timerCapture) {
                            clearTimeout(this.timerCapture);
                        }
                        proms = function () {
                            var p = new Promise(function (resolve) { return __awaiter(_this, void 0, void 0, function () {
                                var code, imageData;
                                var _this = this;
                                return __generator(this, function (_a) {
                                    if (videoElem.videoWidth && videoElem.videoHeight) {
                                        imageData = this._createImageData(videoElem, videoElem.videoWidth, videoElem.videoHeight);
                                        code = jsQR__default["default"](imageData.data, imageData.width, imageData.height, options);
                                        if (code) {
                                            resolve(code);
                                        }
                                        else {
                                            this.timerCapture = setTimeout(function () { return __awaiter(_this, void 0, void 0, function () {
                                                return __generator(this, function (_a) {
                                                    switch (_a.label) {
                                                        case 0: return [4 /*yield*/, this._captureToCanvas(videoElem, options)];
                                                        case 1:
                                                            code = _a.sent();
                                                            resolve(code);
                                                            return [2 /*return*/];
                                                    }
                                                });
                                            }); }, 500);
                                        }
                                    }
                                    else {
                                        this.timerCapture = setTimeout(function () { return __awaiter(_this, void 0, void 0, function () {
                                            return __generator(this, function (_a) {
                                                switch (_a.label) {
                                                    case 0: return [4 /*yield*/, this._captureToCanvas(videoElem, options)];
                                                    case 1:
                                                        code = _a.sent();
                                                        resolve(code);
                                                        return [2 /*return*/];
                                                }
                                            });
                                        }); }, 500);
                                    }
                                    return [2 /*return*/];
                                });
                            }); });
                            return p;
                        };
                        return [4 /*yield*/, proms()];
                    case 1:
                        result = _a.sent();
                        return [2 /*return*/, result];
                }
            });
        });
    };
    /**
     * Prepares the video element for receiving
     * camera's input. Releases a stream if there
     * was any (resets).
     *
     * @param  {DOMElement} videoElem <video> dom element
     * @param  {Object} options     options (optional) - Additional options.
     *  inversionAttempts - (attemptBoth (default), dontInvert, onlyInvert, or invertFirst)
     *  refer to jsqr options: https://github.com/cozmo/jsQR
     */
    QrcodeDecoder.prototype.decodeFromCamera = function (videoElem, options) {
        if (options === void 0) { options = {}; }
        return __awaiter(this, void 0, void 0, function () {
            var opts, stream, e_1, code;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        opts = __assign(__assign({}, this.defaultOption), options);
                        this.stop();
                        if (!navigator.mediaDevices.getUserMedia) {
                            throw new Error("Couldn't get video from camera");
                        }
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 3, , 7]);
                        return [4 /*yield*/, navigator.mediaDevices.getUserMedia(this.videoConstraints)];
                    case 2:
                        stream = _a.sent();
                        return [3 /*break*/, 7];
                    case 3:
                        e_1 = _a.sent();
                        if (!(e_1.name === 'OverconstrainedError')) return [3 /*break*/, 5];
                        console.log('[OverconstrainedError] Can not use rear camera.');
                        return [4 /*yield*/, navigator.mediaDevices.getUserMedia({
                                video: __assign(__assign({}, videoSize), {
                                    width: opts.width,
                                    height: opts.height,
                                }),
                                audio: false,
                            })];
                    case 4:
                        stream = _a.sent();
                        return [3 /*break*/, 6];
                    case 5: throw e_1;
                    case 6: return [3 /*break*/, 7];
                    case 7:
                        if (!stream) return [3 /*break*/, 9];
                        videoElem.srcObject = stream;
                        // videoElem.src = window.URL.createObjectURL(stream);
                        this.videoElem = videoElem;
                        this.stream = stream;
                        return [4 /*yield*/, this.decodeFromVideo(videoElem, opts)];
                    case 8:
                        code = _a.sent();
                        return [2 /*return*/, code];
                    case 9: return [2 /*return*/, null];
                }
            });
        });
    };
    /**
     * Prepares the video element for video file.
     *
     * @param  {DOMElement} videoElem <video> dom element
     * @param  {Object} options     options (optional) - Additional options.
     *  inversionAttempts - (attemptBoth (default), dontInvert, onlyInvert, or invertFirst)
     *  refer to jsqr options: https://github.com/cozmo/jsQR
     */
    QrcodeDecoder.prototype.decodeFromVideo = function (videoElem, options) {
        if (options === void 0) { options = {}; }
        return __awaiter(this, void 0, void 0, function () {
            var opts, code, e_2;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        opts = __assign(__assign({}, this.defaultOption), options);
                        _a.label = 1;
                    case 1:
                        _a.trys.push([1, 3, , 4]);
                        this.videoElem = videoElem;
                        return [4 /*yield*/, this._captureToCanvas(videoElem, opts)];
                    case 2:
                        code = _a.sent();
                        return [2 /*return*/, code];
                    case 3:
                        e_2 = _a.sent();
                        throw e_2;
                    case 4: return [2 /*return*/];
                }
            });
        });
    };
    /**
     * Decodes an image from its src.
     * @param  {DOMElement} imageElem
     * @param  {Object} options     options (optional) - Additional options.
     *  inversionAttempts - (attemptBoth (default), dontInvert, onlyInvert, or invertFirst)
     *  refer to jsqr options: https://github.com/cozmo/jsQR
     */
    QrcodeDecoder.prototype.decodeFromImage = function (img, options) {
        if (options === void 0) { options = {}; }
        return __awaiter(this, void 0, void 0, function () {
            var imgDom, opts, proms, code;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        imgDom = null;
                        opts = __assign(__assign({}, this.defaultOption), options);
                        if (!(typeof img === 'string')) return [3 /*break*/, 2];
                        imgDom = document.createElement('img');
                        if (options.crossOrigin) {
                            imgDom.crossOrigin = options.crossOrigin;
                        }
                        imgDom.src = img;
                        proms = function () {
                            return new Promise(function (resolve) {
                                imgDom.onload = function () { return resolve(true); };
                            });
                        };
                        return [4 /*yield*/, proms()];
                    case 1:
                        _a.sent();
                        return [3 /*break*/, 3];
                    case 2:
                        if (+img.nodeType > 0) {
                            if (!img.src) {
                                throw new Error('The ImageElement must contain a src');
                            }
                            imgDom = img;
                        }
                        _a.label = 3;
                    case 3:
                        code = null;
                        if (imgDom) {
                            code = this._decodeFromImageElm(imgDom, opts);
                        }
                        return [2 /*return*/, code];
                }
            });
        });
    };
    QrcodeDecoder.prototype._decodeFromImageElm = function (imgObj, options) {
        if (options === void 0) { options = {}; }
        var opts = __assign(__assign({}, this.defaultOption), options);
        var imageData = this._createImageData(imgObj, imgObj.width, imgObj.height);
        var code = jsQR__default["default"](imageData.data, imageData.width, imageData.height, opts);
        if (code) {
            return code;
        }
        return null;
    };
    /**
     * Releases a video stream that was being
     * captured by prepareToVideo
     */
    QrcodeDecoder.prototype.stop = function () {
        if (this.stream) {
            var track = this.stream.getTracks()[0];
            track.stop();
            this.stream = null;
            // fix: clear black bg after camera capture
            this.videoElem.srcObject = null;
        }
        if (this.timerCapture) {
            clearTimeout(this.timerCapture);
            this.timerCapture = null;
        }
        return this;
    };
    /**
     * Sets the sourceId for the camera to use.
     */
    QrcodeDecoder.prototype.setGroupId = function (groupId) {
        if (groupId) {
            this.videoConstraints.video = {
                advanced: [{ groupId: groupId }],
            };
        }
        else {
            this.videoConstraints.video = true;
        }
        return this;
    };
    /**
     * Gets a list of all available video sources on
     * the current device.
     */
    QrcodeDecoder.prototype.getVideoDevices = function () {
        return __awaiter(this, void 0, void 0, function () {
            var devices;
            return __generator(this, function (_a) {
                switch (_a.label) {
                    case 0:
                        if (!navigator.mediaDevices.enumerateDevices) return [3 /*break*/, 2];
                        return [4 /*yield*/, navigator.mediaDevices.enumerateDevices()];
                    case 1:
                        devices = _a.sent();
                        return [2 /*return*/, devices.filter(function (item) {
                                if (item.kind === 'videoinput') {
                                    return true;
                                }
                                return false;
                            })];
                    case 2: throw new Error('Current browser doest not support MediaStreamTrack.getSources');
                }
            });
        });
    };
    return QrcodeDecoder;
}());

exports.QrcodeDecoder = QrcodeDecoder;
exports["default"] = QrcodeDecoder;
