'use strict';

const { createReadStream } = require('fs');
const { join } = require('path');

function routes(app, middleware, options) {
  app.get('/__webpack_dev_server__/live.bundle.js', (req, res) => {
    res.setHeader('Content-Type', 'application/javascript');

    createReadStream(
      join(__dirname, '..', '..', 'client', 'live.bundle.js')
    ).pipe(res);
  });

  app.get('/__webpack_dev_server__/sockjs.bundle.js', (req, res) => {
    res.setHeader('Content-Type', 'application/javascript');

    createReadStream(
      join(__dirname, '..', '..', 'client', 'sockjs.bundle.js')
    ).pipe(res);
  });

  app.get('/webpack-dev-server.js', (req, res) => {
    res.setHeader('Content-Type', 'application/javascript');

    createReadStream(
      join(__dirname, '..', '..', 'client', 'index.bundle.js')
    ).pipe(res);
  });

  app.get('/webpack-dev-server/*', (req, res) => {
    res.setHeader('Content-Type', 'text/html');

    createReadStream(join(__dirname, '..', '..', 'client', 'live.html')).pipe(
      res
    );
  });

  app.get('/webpack-dev-server', (req, res) => {
    res.setHeader('Content-Type', 'text/html');

    res.write(
      '<!DOCTYPE html><html><head><meta charset="utf-8"/></head><body>'
    );

    const outputPath = middleware.getFilenameFromUrl(options.publicPath || '/');
    const filesystem = middleware.fileSystem;

    writeDirectory(options.publicPath || '/', outputPath);

    res.end('</body></html>');

    function writeDirectory(baseUrl, basePath) {
      const content = filesystem.readdirSync(basePath);

      res.write('<ul>');

      content.forEach((item) => {
        const p = `${basePath}/${item}`;

        if (filesystem.statSync(p).isFile()) {
          res.write('<li><a href="');
          res.write(baseUrl + item);
          res.write('">');
          res.write(item);
          res.write('</a></li>');

          if (/\.js$/.test(item)) {
            const html = item.substr(0, item.length - 3);

            res.write('<li><a href="');
            res.write(baseUrl + html);
            res.write('">');
            res.write(html);
            res.write('</a> (magic html for ');
            res.write(item);
            res.write(') (<a href="');
            res.write(
              baseUrl.replace(
                // eslint-disable-next-line
                /(^(https?:\/\/[^\/]+)?\/)/,
                '$1webpack-dev-server/'
              ) + html
            );
            res.write('">webpack-dev-server</a>)</li>');
          }
        } else {
          res.write('<li>');
          res.write(item);
          res.write('<br>');

          writeDirectory(`${baseUrl + item}/`, p);

          res.write('</li>');
        }
      });

      res.write('</ul>');
    }
  });
}

module.exports = routes;
