package com.teemlink.run;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.domain.EntityScan;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;
import org.springframework.data.jpa.repository.config.EnableJpaRepositories;

@SpringBootApplication
@ComponentScan(basePackages = { "com.teemlink.run","cn.myapps.common.util","com.teemlink.conf", "com.teemlink.km.**.controller",
		"cn.myapps.authtime.**.controller","cn.myapps.authtime.common.dao","cn.myapps.runtime.**.dao",
		"com.teemlink.km.**.service", "com.teemlink.km.search.engine","com.teemlink.km.monitorconver.**","com.teemlink.km.**.dao", "cn.myapps.common.dao","com.teemlink.login",
		"com.teemlink.km.log.aspect", "com.teemlink.km.user.model" })
@EnableJpaRepositories("com.teemlink.login.dao")
@EntityScan("com.teemlink.login.model")
@EnableFeignClients(basePackages = {"com.teemlink.conf","com.teemlink.km.common.service"})
//@EnableRedisHttpSession
public class KmsAppWithWar extends SpringBootServletInitializer {

	public static void main(String[] args) {
		SpringApplication.run(KmsAppWithWar.class, args);
	}

	@Override
	protected SpringApplicationBuilder configure(SpringApplicationBuilder builder) {
		return builder.sources(KmsAppWithWar.class);
	}
}
