package cn.myapps.run;

import org.springframework.boot.SpringApplication;
import org.springframework.boot.autoconfigure.SpringBootApplication;
import org.springframework.boot.autoconfigure.jdbc.DataSourceAutoConfiguration;
import org.springframework.boot.builder.SpringApplicationBuilder;
import org.springframework.boot.web.servlet.support.SpringBootServletInitializer;
import org.springframework.cloud.openfeign.EnableFeignClients;
import org.springframework.context.annotation.ComponentScan;

@SpringBootApplication(exclude = { DataSourceAutoConfiguration.class })
@ComponentScan(basePackages = { "cn.myapps.run","cn.myapps.conf", "cn.myapps.macro",
//		"cn.myapps.runtime.**.service",
		"cn.myapps.designtime.**.controller",
		"cn.myapps.designtime.**.action",
		"cn.myapps.authtime.**.action", 
		"cn.myapps.common.util", "cn.myapps.util",
		"cn.myapps.common.exception", 
		"cn.myapps.common.dao",
		"cn.myapps.designtime.**.dao",
		"cn.myapps.designtime.report",
		////"cn.myapps.runtime.common.utils",
		"cn.myapps.runtime.**.dao",
		"cn.myapps.scheduler"
})
@EnableFeignClients(basePackages = "cn.myapps.designtime.report.feignservice")
public class DesignerAppWithWar extends SpringBootServletInitializer {

	public static void main(String[] args) {
		SpringApplication.run(DesignerAppWithWar.class, args);
	}

	@Override
	protected SpringApplicationBuilder configure(SpringApplicationBuilder builder) {
		return builder.sources(DesignerAppWithWar.class);
	}
}
