# @turf/isobands

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## isobands

Takes a square or rectangular grid [FeatureCollection][1] of [Point][2] features with z-values and an array of
value breaks and generates filled contour isobands.

**Parameters**

-   `pointGrid` **[FeatureCollection][3]&lt;[Point][4]>** input points - must be square or rectangular
-   `breaks` **[Array][5]&lt;[number][6]>** where to draw contours
-   `options` **[Object][7]** options on output (optional, default `{}`)
    -   `options.zProperty` **[string][8]** the property name in `points` from which z-values will be pulled (optional, default `'elevation'`)
    -   `options.commonProperties` **[Object][7]** GeoJSON properties passed to ALL isobands (optional, default `{}`)
    -   `options.breaksProperties` **[Array][5]&lt;[Object][7]>** GeoJSON properties passed, in order, to the correspondent isoband (order defined by breaks) (optional, default `[]`)

Returns **[FeatureCollection][3]&lt;[MultiPolygon][9]>** a FeatureCollection of [MultiPolygon][10] features representing isobands

[1]: https://tools.ietf.org/html/rfc7946#section-3.3

[2]: https://tools.ietf.org/html/rfc7946#section-3.1.2

[3]: https://tools.ietf.org/html/rfc7946#section-3.3

[4]: https://tools.ietf.org/html/rfc7946#section-3.1.2

[5]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array

[6]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[7]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[8]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/String

[9]: https://tools.ietf.org/html/rfc7946#section-3.1.7

[10]: https://tools.ietf.org/html/rfc7946#section-3.1.7

<!-- This file is automatically generated. Please don't edit it directly:
if you find an error, edit the source file (likely index.js), and re-run
./scripts/generate-readmes in the turf project. -->

---

This module is part of the [Turfjs project](http://turfjs.org/), an open source
module collection dedicated to geographic algorithms. It is maintained in the
[Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create
PRs and issues.

### Installation

Install this module individually:

```sh
$ npm install @turf/isobands
```

Or install the Turf module that includes it as a function:

```sh
$ npm install @turf/turf
```
