import { FeatureCollection, Point, BBox, Polygon } from 'geojson';

/**
 * Takes a collection of points and a bounding box, and returns a collection
 * of Voronoi polygons.
 *
 * The Voronoi algorithim used comes from the d3-voronoi package.
 *
 * @function
 * @param {FeatureCollection<Point>} points points around which to calculate the Voronoi polygons
 * @param {Object} [options={}] Optional parameters
 * @param {BBox} [options.bbox=[-180, -85, 180, -85]] clipping rectangle, in [minX, minY, maxX, MaxY] order
 * @returns {FeatureCollection<Polygon>} a set of polygons, one per input point
 * @example
 * const options = {
 *   bbox: [-70, 40, -60, 60]
 * };
 * const points = turf.randomPoint(100, options);
 * const voronoiPolygons = turf.voronoi(points, options);
 *
 * //addToMap
 * const addToMap = [voronoiPolygons, points];
 */
declare function voronoi(points: FeatureCollection<Point>, options?: {
    bbox?: BBox;
}): FeatureCollection<Polygon>;

export { voronoi as default, voronoi };
