import { GeoJsonProperties, BBox, Feature, Polygon, FeatureCollection } from 'geojson';
import { Units } from '@turf/helpers';

/**
 * Creates a grid of triangular polygons.
 *
 * @function
 * @param {BBox} bbox extent of grid in [minX, minY, maxX, maxY] order
 * @param {number} cellSide dimension of each grid cell.  Two triangles are created in each cell.
 * @param {Object} [options={}] Optional parameters
 * @param {Units} [options.units='kilometers'] used in calculating cellSide.  Supports all valid Turf {@link https://github.com/Turfjs/turf/blob/master/packages/turf-helpers/README_UNITS.md Units}
 * @param {Feature<Polygon>} [options.mask] if passed a Polygon or MultiPolygon, the grid Points will be created only inside it
 * @param {Object} [options.properties={}] passed to each point of the grid
 * @returns {FeatureCollection<Polygon>} grid of polygons
 * @example
 * var bbox = [-95, 30 ,-85, 40];
 * var cellSide = 50;
 * var options = {units: 'miles'};
 *
 * var triangleGrid = turf.triangleGrid(bbox, cellSide, options);
 *
 * //addToMap
 * var addToMap = [triangleGrid];
 */
declare function triangleGrid<P extends GeoJsonProperties = GeoJsonProperties>(bbox: BBox, cellSide: number, options?: {
    units?: Units;
    properties?: P;
    mask?: Feature<Polygon>;
}): FeatureCollection<Polygon, P>;

export { triangleGrid as default, triangleGrid };
