import { Feature, Polygon, MultiPolygon, FeatureCollection } from 'geojson';

/**
 * Tesselates a polygon or multipolygon into a collection of triangle polygons
 * using [earcut](https://github.com/mapbox/earcut).
 *
 * @function
 * @param {Feature<Polygon|MultiPolygon>} poly the polygon to tesselate
 * @returns {FeatureCollection<Polygon>} collection of polygon tesselations
 * @example
 * const poly = turf.polygon([[[11, 0], [22, 4], [31, 0], [31, 11], [21, 15], [11, 11], [11, 0]]]);
 * const triangles = turf.tesselate(poly);
 *
 * //addToMap
 * const addToMap = [poly, triangles]
 */
declare function tesselate(poly: Feature<Polygon | MultiPolygon>): FeatureCollection<Polygon>;

export { tesselate as default, tesselate };
