// index.ts
import { circle } from "@turf/circle";
import { lineArc } from "@turf/line-arc";
import { coordEach } from "@turf/meta";
import { isObject, polygon } from "@turf/helpers";
import { getCoords } from "@turf/invariant";
function sector(center, radius, bearing1, bearing2, options = {}) {
  options = options || {};
  if (!isObject(options)) throw new Error("options is invalid");
  const properties = options.properties;
  if (!center) throw new Error("center is required");
  if (bearing1 === void 0 || bearing1 === null)
    throw new Error("bearing1 is required");
  if (bearing2 === void 0 || bearing2 === null)
    throw new Error("bearing2 is required");
  if (!radius) throw new Error("radius is required");
  if (typeof options !== "object") throw new Error("options must be an object");
  if (convertAngleTo360(bearing1) === convertAngleTo360(bearing2)) {
    return circle(center, radius, options);
  }
  const coords = getCoords(center);
  const arc = lineArc(center, radius, bearing1, bearing2, options);
  const sliceCoords = [[coords]];
  coordEach(arc, function(currentCoords) {
    sliceCoords[0].push(currentCoords);
  });
  sliceCoords[0].push(coords);
  return polygon(sliceCoords, properties);
}
function convertAngleTo360(alpha) {
  let beta = alpha % 360;
  if (beta < 0) {
    beta += 360;
  }
  return beta;
}
var turf_sector_default = sector;
export {
  turf_sector_default as default,
  sector
};
//# sourceMappingURL=index.js.map