# @turf/quadrat-analysis

<!-- Generated by documentation.js. Update this documentation by updating the source code. -->

## quadratAnalysis

Quadrat analysis lays a set of equal-size areas(quadrat) over the study area and counts
the number of features in each quadrat and creates a frequency table.
The table lists the number of quadrats containing no features,
the number containing one feature, two features, and so on,
all the way up to the quadrat containing the most features.
The method then creates the frequency table for the random distribution, usually based on a Poisson distribution.
The method uses the distribution to calculate the probability for 0 feature occuring,
1 feature occuring, 2 features, and so on,
and lists these probabilities in the frequency table.
By comparing the two frequency tables, you can see whether the features create a pattern.
If the table for the observed distribution has more quadrats containing many features than the
table for the random distribution dose, then the features create a clustered pattern.

It is hard to judge the frequency tables are similar or different just by looking at them.
So, we can use serval statistical tests to find out how much the frequency tables differ.
We use Kolmogorov-Smirnov test.This method calculates cumulative probabilities for both distributions,
and then compares the cumulative probabilities at each class level and selects the largest absolute difference D.
Then, the test compares D to the critical value for a confidence level you specify.
If D is greater than the critical value, the difference between  the observed distribution and
the random distribution is significant. The greater the value the bigger the difference.

Traditionally, squares are used for the shape of the quadrats, in a regular grid(square-grid).
Some researchers suggest that the quadrat size equal twice the size of mean area per feature,
which is simply the area of the study area divided by the number of features.

### Parameters

*   `pointFeatureSet` **[FeatureCollection][1]<[Point][2]>** point set to study
*   `options` **[Object][3]** optional parameters (optional, default `{}`)

    *   `options.studyBbox` **\[[number][4], [number][4], [number][4], [number][4]]?** bbox representing the study area
    *   `options.confidenceLevel` **(`20` | `15` | `10` | `5` | `2` | `1`)** a confidence level.
        The unit is percentage . 5 means 95%, value must be in [K\_TABLE][5] (optional, default `20`)

### Examples

```javascript
var bbox = [-65, 40, -63, 42];
var dataset = turf.randomPoint(100, { bbox: bbox });
var result = turf.quadratAnalysis(dataset);
```

Returns **[QuadratAnalysisResult][6]** result

## K\_TABLE

the confidence level

Type: [Object][3]

### Properties

*   `20` **[number][4]** 1.07275
*   `15` **[number][4]** 1.13795
*   `10` **[number][4]** 1.22385
*   `5` **[number][4]** 1.3581
*   `2` **[number][4]** 1.51743
*   `1` **[number][4]** 1.62762

## QuadratAnalysisResult

the return type of the quadratAnalysis

Type: [object][3]

### Properties

*   `criticalValue` **[number][4]**&#x20;
*   `maxAbsoluteDifference` **[number][4]**&#x20;
*   `isRandom` **[boolean][7]**&#x20;
*   `observedDistribution` **[Array][8]<[number][4]>** the cumulative distribution of observed features,
    the index represents the number of features in the quadrat.

[1]: https://tools.ietf.org/html/rfc7946#section-3.3

[2]: https://tools.ietf.org/html/rfc7946#section-3.1.2

[3]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Object

[4]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Number

[5]: #k_table

[6]: #quadratanalysisresult

[7]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Boolean

[8]: https://developer.mozilla.org/docs/Web/JavaScript/Reference/Global_Objects/Array

<!-- This file is automatically generated. Please don't edit it directly. If you find an error, edit the source file of the module in question (likely index.js or index.ts), and re-run "yarn docs" from the root of the turf project. -->

---

This module is part of the [Turfjs project](https://turfjs.org/), an open source module collection dedicated to geographic algorithms. It is maintained in the [Turfjs/turf](https://github.com/Turfjs/turf) repository, where you can create PRs and issues.

### Installation

Install this single module individually:

```sh
$ npm install @turf/quadrat-analysis
```

Or install the all-encompassing @turf/turf module that includes all modules as functions:

```sh
$ npm install @turf/turf
```
