"use strict";Object.defineProperty(exports, "__esModule", {value: true});// index.ts
var _booleanpointinpolygon = require('@turf/boolean-point-in-polygon');
var _pointtolinedistance = require('@turf/point-to-line-distance');
var _polygontoline = require('@turf/polygon-to-line');
var _invariant = require('@turf/invariant');
var _meta = require('@turf/meta');
var _helpers = require('@turf/helpers');
function pointToPolygonDistance(point, polygonOrMultiPolygon, options = {}) {
  var _a, _b;
  const method = (_a = options.method) != null ? _a : "geodesic";
  const units = (_b = options.units) != null ? _b : "kilometers";
  if (!point) throw new Error("point is required");
  if (!polygonOrMultiPolygon)
    throw new Error("polygon or multi-polygon is required");
  const geom = _invariant.getGeom.call(void 0, polygonOrMultiPolygon);
  if (geom.type === "MultiPolygon") {
    const distances = geom.coordinates.map(
      (coords) => pointToPolygonDistance(point, _helpers.polygon.call(void 0, coords), { method, units })
    );
    return Math.min(...distances.map(Math.abs)) * (_booleanpointinpolygon.booleanPointInPolygon.call(void 0, point, polygonOrMultiPolygon) ? -1 : 1);
  }
  if (geom.coordinates.length > 1) {
    const [exteriorDistance, ...interiorDistances] = geom.coordinates.map(
      (coords) => pointToPolygonDistance(point, _helpers.polygon.call(void 0, [coords]), { method, units })
    );
    if (exteriorDistance >= 0) return exteriorDistance;
    const smallestInteriorDistance = Math.min(...interiorDistances);
    if (smallestInteriorDistance < 0) return Math.abs(smallestInteriorDistance);
    return Math.min(smallestInteriorDistance, Math.abs(exteriorDistance));
  }
  const lines = _polygontoline.polygonToLine.call(void 0, geom);
  let minDistance = Infinity;
  _meta.flattenEach.call(void 0, lines, (feature) => {
    minDistance = Math.min(
      minDistance,
      _pointtolinedistance.pointToLineDistance.call(void 0, point, feature, {
        method,
        units
      })
    );
  });
  return _booleanpointinpolygon.booleanPointInPolygon.call(void 0, point, geom) ? -minDistance : minDistance;
}
var turf_point_to_polygon_distance_default = pointToPolygonDistance;



exports.default = turf_point_to_polygon_distance_default; exports.pointToPolygonDistance = pointToPolygonDistance;
//# sourceMappingURL=index.cjs.map