import { Feature, Geometry } from 'geojson';

/**
 * Determine whether two geometries of the same type have identical X,Y coordinate values.
 * See http://edndoc.esri.com/arcsde/9.0/general_topics/understand_spatial_relations.htm
 *
 * @function
 * @param {Geometry|Feature} feature1 GeoJSON input
 * @param {Geometry|Feature} feature2 GeoJSON input
 * @param {Object} [options={}] Optional parameters
 * @param {number} [options.precision=6] decimal precision to use when comparing coordinates
 * @returns {boolean} true if the objects are equal, false otherwise
 * @example
 * var pt1 = turf.point([0, 0]);
 * var pt2 = turf.point([0, 0]);
 * var pt3 = turf.point([1, 1]);
 *
 * turf.booleanEqual(pt1, pt2);
 * //= true
 * turf.booleanEqual(pt2, pt3);
 * //= false
 */
declare function booleanEqual(feature1: Feature<any> | Geometry, feature2: Feature<any> | Geometry, options?: {
    precision?: number;
}): boolean;

export { booleanEqual, booleanEqual as default };
