# dispatch-platform-mobile

## 起步

### 安装
#### pnpm(推荐)
pnpm安装参考[pnpm文档](https://pnpm.io/zh)
```
pnpm install
```
#### npm
```
npm install
```
#### 安装解决依赖冲突
```
npm install --legacy-peer-deps
```

### 开发环境启动
```
npm run serve
```

### 测试环境打包
```
npm run build
```

### 正式环境打包
```
npm run build:prod
```

## 环境说明

[参考文档](https://cli.vuejs.org/zh/guide/mode-and-env.html)

| 环境文件               | node: process.env.NODE_ENV / process.env.ENV | 说明   |
|--------------------|----------------------------------------------|------|
| `.env.development` | `development`/`development`                  | 开发环境 |
| `.env.staging`     | `production`/`staging`                       | 测试环境 |
| `.env.production`  | `production`/`production`                    | 正式环境 |


## Vant2

通用组件如：表单、按钮等组件基于Vant2开发

> 参考文档：[vant^2.12.54](https://vant-contrib.gitee.io/vant/v2/#/zh-CN/home)

## IM

> 产品文档：[即时通信 IM](https://cloud.tencent.com/document/product/269)
>
> SDK API：[腾讯云即时通信IM SDK](https://web.sdk.qcloud.com/im/doc/zh-cn/index.html)

### IM组件

* 组件路径： `src/components/timApp`
    * 会话列表：`src/components/timApp/conversation/message-list.vue`
    * 消息框主体：`src/components/timApp/conversation/current-conversation.vue`
        * 消息组件：`src/components/timApp/messages/*`

## TRTC
> 产品文档：[实时音视频](https://cloud.tencent.com/document/product/647)
>
> SDK API：[TRTC Web SDK](https://web.sdk.qcloud.com/trtc/webrtc/doc/zh-cn/index.html)

### TRTC组件

* 组件路径：`src/components/timApp/trtc/`
  * 音视频框：`src/components/timApp/trtc/calling-index.vue`
  * 参会人弹框：`src/components/timApp/trtc/calling-members.vue`
* 核心功能：`src/components/mixin/rtc.js`

### sdkAppId

- 开发环境：`.env.development`文件中的`VUE_APP_SDK_TRTC_ID` 常量
- 测试环境：`.env.staging`文件中的`VUE_APP_SDK_TRTC_ID` 常量
- 正式环境：`.env.production`文件中的`VUE_APP_SDK_TRTC_ID` 常量

## 高德地图

> 教程：[开发教程](https://lbs.amap.com/api/javascript-api/guide/abc/prepare)
>
> 高德地图 2.0 API：[地图 JSAPI 2.0](https://developer.amap.com/api/jsapi-v2/documentation#%e5%9c%b0%e5%9b%be-jsapi-2-0)

### 高德地图组件

* 组件路径：`src/components/AMap`
    * 地图主体：`src/components/AMap/map/index.vue`
    * 弹框主题：`src/components/infoPanel/index.vue`
      * 弹框内容：`src/components/AMap/infoPanel/*`

### 高德地图开发者Key

配置地址：`public/config/json`
```json
{
  "load": {
    "key": "******"
  }
}
```

## OpenLayers

> API文档：[ol: ^7](https://openlayers.org/en/latest/apidoc/)


