/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.sdk.messagecontent;

import cn.wildfirechat.pojos.MessagePayload;
import cn.wildfirechat.sdk.messagecontent.MessageContent;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class NotDeliveredMessageContent
extends MessageContent {
    private int type;
    private long messageUid;
    private boolean allFailure;
    private List<String> userIds;
    private int localImErrorCode;
    private int localBridgeErrorCode;
    private int remoteBridgeErrorCode;
    private int remoteServerErrorCode;
    private String errorMessage;

    @Override
    public int getContentType() {
        return 16;
    }

    @Override
    public int getPersistFlag() {
        return 1;
    }

    @Override
    public MessagePayload encode() {
        MessagePayload payload = super.encode();
        JSONObject obj = new JSONObject();
        obj.put((Object)"mid", (Object)this.messageUid);
        obj.put((Object)"all", (Object)this.allFailure);
        obj.put((Object)"us", this.userIds);
        obj.put((Object)"lme", (Object)this.localImErrorCode);
        obj.put((Object)"lbe", (Object)this.localBridgeErrorCode);
        obj.put((Object)"rbe", (Object)this.remoteBridgeErrorCode);
        obj.put((Object)"rme", (Object)this.remoteServerErrorCode);
        obj.put((Object)"em", (Object)this.errorMessage);
        payload.setBase64edData(Base64.getEncoder().encodeToString(obj.toString().getBytes()));
        return payload;
    }

    @Override
    public void decode(MessagePayload payload) {
        try {
            super.decode(payload);
            JSONObject obj = (JSONObject)new JSONParser().parse(new String(Base64.getDecoder().decode(payload.getBase64edData())));
            this.messageUid = (Long)obj.get((Object)"mid");
            this.allFailure = (Boolean)obj.get((Object)"all");
            this.userIds = new ArrayList<String>();
            JSONArray arr = (JSONArray)obj.get((Object)"us");
            if (arr != null) {
                for (int i = 0; i < arr.size(); ++i) {
                    this.userIds.add((String)arr.get(i));
                }
            }
            this.localImErrorCode = (Integer)obj.get((Object)"lme");
            this.localBridgeErrorCode = (Integer)obj.get((Object)"lbe");
            this.remoteBridgeErrorCode = (Integer)obj.get((Object)"rbe");
            this.remoteServerErrorCode = (Integer)obj.get((Object)"rme");
            this.errorMessage = (String)obj.get((Object)"em");
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

