/*
 * Decompiled with CFR 0.152.
 */
package cn.wildfirechat.sdk.messagecontent;

import cn.wildfirechat.pojos.MessagePayload;
import cn.wildfirechat.sdk.messagecontent.MessageContent;
import io.netty.util.internal.StringUtil;
import java.util.ArrayList;
import java.util.Base64;
import java.util.List;
import org.json.simple.JSONArray;
import org.json.simple.JSONObject;
import org.json.simple.parser.JSONParser;
import org.json.simple.parser.ParseException;

public class CallStartMessageContent
extends MessageContent {
    private String callId;
    private List<String> targetIds;
    private long connectTime;
    private long endTime;
    private boolean audioOnly;
    private String pin;
    private int status;
    private int type;

    public CallStartMessageContent() {
    }

    public CallStartMessageContent(String callId, List<String> targetIds, boolean audioOnly) {
        this.callId = callId;
        this.audioOnly = audioOnly;
        this.targetIds = targetIds;
    }

    public String getCallId() {
        return this.callId;
    }

    public void setCallId(String callId) {
        this.callId = callId;
    }

    public long getConnectTime() {
        return this.connectTime;
    }

    public void setConnectTime(long connectTime) {
        this.connectTime = connectTime;
    }

    public long getEndTime() {
        return this.endTime;
    }

    public void setEndTime(long endTime) {
        this.endTime = endTime;
    }

    public int getStatus() {
        return this.status;
    }

    public void setStatus(int status) {
        this.status = status;
    }

    public boolean isAudioOnly() {
        return this.audioOnly;
    }

    public void setAudioOnly(boolean audioOnly) {
        this.audioOnly = audioOnly;
    }

    public List<String> getTargetIds() {
        return this.targetIds;
    }

    public void setTargetIds(List<String> targetIds) {
        this.targetIds = targetIds;
    }

    public String getPin() {
        return this.pin;
    }

    public void setPin(String pin) {
        this.pin = pin;
    }

    public int getType() {
        return this.type;
    }

    public void setType(int type) {
        this.type = type;
    }

    @Override
    public int getContentType() {
        return 400;
    }

    @Override
    public int getPersistFlag() {
        return 3;
    }

    @Override
    public MessagePayload encode() {
        MessagePayload payload = super.encode();
        payload.setContent(this.callId);
        payload.setPushContent("\u97f3\u89c6\u9891\u901a\u8bdd\u9080\u8bf7");
        JSONObject objWrite = new JSONObject();
        if (this.connectTime > 0L) {
            objWrite.put((Object)"c", (Object)this.connectTime);
        }
        if (this.endTime > 0L) {
            objWrite.put((Object)"e", (Object)this.endTime);
        }
        if (this.status > 0) {
            objWrite.put((Object)"s", (Object)this.status);
        }
        objWrite.put((Object)"t", (Object)this.targetIds.get(0));
        JSONArray ts = new JSONArray();
        ts.addAll(this.targetIds);
        objWrite.put((Object)"ts", (Object)ts);
        objWrite.put((Object)"a", (Object)(this.audioOnly ? 1 : 0));
        objWrite.put((Object)"p", (Object)this.pin);
        if (this.type > 0) {
            objWrite.put((Object)"ty", (Object)this.type);
        }
        payload.setBase64edData(Base64.getEncoder().encodeToString(objWrite.toString().getBytes()));
        JSONObject pushDataWrite = new JSONObject();
        pushDataWrite.put((Object)"callId", (Object)this.callId);
        pushDataWrite.put((Object)"audioOnly", (Object)this.audioOnly);
        if (this.targetIds != null && this.targetIds.size() > 0) {
            pushDataWrite.put((Object)"participants", this.targetIds);
        }
        payload.setPushData(pushDataWrite.toString());
        return payload;
    }

    @Override
    public void decode(MessagePayload payload) {
        super.decode(payload);
        this.callId = payload.getContent();
        try {
            if (!StringUtil.isNullOrEmpty((String)payload.getBase64edData())) {
                JSONObject jsonObject = (JSONObject)new JSONParser().parse(new String(Base64.getDecoder().decode(payload.getBase64edData())));
                this.connectTime = (Long)jsonObject.get((Object)"c");
                this.endTime = (Long)jsonObject.get((Object)"e");
                this.status = (Integer)jsonObject.get((Object)"s");
                this.pin = (String)jsonObject.get((Object)"p");
                this.type = (Integer)jsonObject.get((Object)"ty");
                JSONArray array = (JSONArray)jsonObject.get((Object)"ts");
                this.targetIds = new ArrayList<String>();
                if (array == null) {
                    this.targetIds.add((String)jsonObject.get((Object)"t"));
                } else {
                    for (int i = 0; i < array.size(); ++i) {
                        if (!(array.get(i) instanceof String)) continue;
                        this.targetIds.add((String)array.get(i));
                    }
                }
                this.audioOnly = (Integer)jsonObject.get((Object)"a") > 0;
            }
        }
        catch (ParseException e) {
            throw new RuntimeException(e);
        }
    }
}

