CREATE TABLE `sp_activity_history` (
  `id` int(11) NOT NULL AUTO_INCREMENT,
  `userId` int(11) NOT NULL COMMENT '录入人员',
  `addTime` datetime DEFAULT NULL,
  `updateTime` datetime DEFAULT NULL,
  `name` varchar(255) DEFAULT NULL COMMENT '活动名称',
  `activityNo` varchar(100) DEFAULT NULL COMMENT '活动编号',
  `activityType` varchar(45) DEFAULT NULL,
  `province` varchar(45) DEFAULT NULL,
  `city` varchar(45) DEFAULT NULL,
  `area` varchar(45) DEFAULT NULL,
  `address` varchar(500) DEFAULT NULL,
  `peakNumber` varchar(10) DEFAULT NULL COMMENT '活动期间单日最大参加人数',
  `startDate` datetime DEFAULT NULL,
  `endDate` datetime DEFAULT NULL,
  `sponsor` varchar(500) DEFAULT NULL COMMENT '承办方',
  `organizer` varchar(255) DEFAULT NULL COMMENT '主办方',
  `assessment` varchar(255) DEFAULT NULL COMMENT '评估机构',
  `addressType` varchar(255) DEFAULT NULL COMMENT '场地类型',
  `pgbg` varchar(255) DEFAULT '' COMMENT '评估报告',
  `bbcl` varchar(255) DEFAULT '' COMMENT '报备材料',
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8;

ALTER TABLE `surveyinfo`
ADD COLUMN `pssInfoId` int(11) NULL COMMENT 'PSS意见id' AFTER `surveyId`;

#杭州
INSERT INTO `config`( `key`, `value`) VALUES ('switch_copyDir', 'on');
INSERT INTO `config`( `key`, `value`) VALUES ('copyDir_path', 'D:/data/pss/material/guangxi_cp/');

#陕西
update config set `value` = '/shanxi/neisnga-manual.pdf' where `key` = 'helpdoc_url';

#广西
update config set `value` = '/guangxi/neigxga-manual.pdf' where `key` = 'helpdoc_url';

#浙江
update config set `value` = '/zhejiang/neizjga-manual.pdf' where `key` = 'helpdoc_url';