-- 大活审批系统，数据库脚本
ALTER TABLE sp_activity_assessment ADD COLUMN `pssId` bigint(15) DEFAULT NULL COMMENT 'pss服务商Id';
ALTER TABLE sp_activity_assessment ADD COLUMN `assessmentType` varchar(45) DEFAULT NULL COMMENT '承办者类型';
ALTER TABLE sp_activity_assessment ADD COLUMN `province` varchar(45) DEFAULT NULL COMMENT '省';
ALTER TABLE sp_activity_assessment ADD COLUMN `city` varchar(45) DEFAULT NULL COMMENT '市';
ALTER TABLE sp_activity_assessment ADD COLUMN `area` varchar(45) DEFAULT NULL COMMENT '区县';
ALTER TABLE sp_activity_assessment ADD COLUMN `organizationCode` varchar(45) DEFAULT NULL COMMENT '组织代码';
ALTER TABLE sp_activity_assessment ADD COLUMN `orgUrl` varchar(255) DEFAULT NULL COMMENT '营业执照图片地址';
ALTER TABLE sp_activity_assessment ADD COLUMN `adminTel` varchar(11) DEFAULT NULL COMMENT '管理员手机';
ALTER TABLE sp_activity_assessment ADD COLUMN `email` varchar(45) DEFAULT NULL COMMENT '邮箱';
ALTER TABLE sp_activity_assessment ADD COLUMN `applyTime` datetime DEFAULT NULL COMMENT '申请时间';
ALTER TABLE sp_activity_assessment ADD COLUMN `updater` varchar(45) DEFAULT NULL;
ALTER TABLE sp_activity_assessment ADD COLUMN `isFreeze` int(10) unsigned zerofill DEFAULT NULL COMMENT '是否冻结，0否，1是';
ALTER TABLE sp_activity_assessment ADD COLUMN `approveStatus` int(10) unsigned zerofill DEFAULT NULL COMMENT '审批状态 1.通过，2.不通过，其它.审批中';
ALTER TABLE sp_activity_assessment ADD COLUMN `isSync` int(10) unsigned zerofill DEFAULT NULL COMMENT '是否需要同步：0.否，1是';
ALTER TABLE sp_activity_assessment ADD COLUMN `contact` varchar(45) DEFAULT NULL COMMENT '联系人';
ALTER TABLE sp_activity_assessment ADD COLUMN `phone` varchar(45) DEFAULT NULL COMMENT '联系电话';

ALTER TABLE sp_activity_contractor ADD COLUMN `pssId` bigint(15) DEFAULT NULL COMMENT 'pss服务商Id';
ALTER TABLE sp_activity_contractor ADD COLUMN `contractorType` varchar(45) DEFAULT NULL COMMENT '承办者类型';
ALTER TABLE sp_activity_contractor ADD COLUMN `province` varchar(45) DEFAULT NULL COMMENT '省';
ALTER TABLE sp_activity_contractor ADD COLUMN `city` varchar(45) DEFAULT NULL COMMENT '市';
ALTER TABLE sp_activity_contractor ADD COLUMN `area` varchar(45) DEFAULT NULL COMMENT '区县';
ALTER TABLE sp_activity_contractor ADD COLUMN `organizationCode` varchar(45) DEFAULT NULL COMMENT '组织代码';
ALTER TABLE sp_activity_contractor ADD COLUMN `orgUrl` varchar(255) DEFAULT NULL COMMENT '营业执照图片地址';
ALTER TABLE sp_activity_contractor ADD COLUMN `adminTel` varchar(11) DEFAULT NULL COMMENT '管理员手机';
ALTER TABLE sp_activity_contractor ADD COLUMN `email` varchar(45) DEFAULT NULL COMMENT '邮箱';
ALTER TABLE sp_activity_contractor ADD COLUMN `applyTime` datetime DEFAULT NULL COMMENT '申请时间';
ALTER TABLE sp_activity_contractor ADD COLUMN `updater` varchar(45) DEFAULT NULL;
ALTER TABLE sp_activity_contractor ADD COLUMN `isFreeze` int(10) unsigned zerofill DEFAULT NULL COMMENT '是否冻结，0否，1是';
ALTER TABLE sp_activity_contractor ADD COLUMN `approveStatus` int(10) unsigned zerofill DEFAULT NULL COMMENT '审批状态 1.通过，2.不通过，其它.审批中';
ALTER TABLE sp_activity_contractor ADD COLUMN `isSync` int(10) unsigned zerofill DEFAULT NULL COMMENT '是否需要同步：0.否，1是';
ALTER TABLE sp_activity_contractor ADD COLUMN `contact` varchar(45) DEFAULT NULL COMMENT '联系人';
ALTER TABLE sp_activity_contractor ADD COLUMN `phone` varchar(45) DEFAULT NULL COMMENT '联系电话';
ALTER TABLE sp_activity_contractor MODIFY COLUMN `activityId` int(11) NULL COMMENT '活动id' AFTER `id`;


CREATE TABLE `sp_activity_plan` (
  `activityPlanId` bigint(15) NOT NULL AUTO_INCREMENT COMMENT '主键',
  `activityId` int(11) NOT NULL COMMENT '活动id',
  `planName` varchar(100) DEFAULT NULL COMMENT '预案名称',
  `planType` varchar(32) DEFAULT NULL COMMENT '预案类型',
  `activityLevel` varchar(10) DEFAULT NULL COMMENT '活动级别',
  `securityLevel` varchar(10) DEFAULT NULL COMMENT '安保级别',
  `classifiedLevel` varchar(10) DEFAULT NULL COMMENT '涉密级别',
  `commander` varchar(30) DEFAULT NULL COMMENT '总指挥',
  `assistantCommander` varchar(64) DEFAULT NULL COMMENT '副总指挥',
  `departmentInvolved` varchar(255) DEFAULT NULL COMMENT '参与部门',
  `grossArea` varchar(32) DEFAULT NULL COMMENT '总面积',
  `involvedNum` varchar(20) DEFAULT NULL COMMENT '参与人数',
  `planDes` varchar(500) DEFAULT NULL COMMENT '预案描述',
  `fileUrl` varchar(255) DEFAULT NULL COMMENT '附件地址',
  `startTime` datetime DEFAULT NULL COMMENT '开始时间',
  `addTime` datetime DEFAULT NULL COMMENT '添加时间',
  `updateTime` datetime DEFAULT NULL COMMENT '修改时间',
  `updater` varchar(45) DEFAULT NULL COMMENT '修改人',
  PRIMARY KEY (`activityPlanId`) USING BTREE
) ENGINE=InnoDB AUTO_INCREMENT=109 DEFAULT CHARSET=utf8 ROW_FORMAT=DYNAMIC;