﻿-- 系统升级记录表
CREATE TABLE `system_upgrade` (
  `id` bigint(22) unsigned NOT NULL AUTO_INCREMENT,
  `title` varchar(255) DEFAULT NULL COMMENT '标题',
  `content` text COMMENT '内容',
  `version` varchar(50) DEFAULT NULL COMMENT '版本',
  `provinceId` varchar(50) DEFAULT NULL COMMENT '省id',
  `cityId` varchar(50) DEFAULT NULL COMMENT '市id',
  `areaId` varchar(50) DEFAULT NULL COMMENT '区id',
  `flag` int(2) DEFAULT NULL,
  `createTime` datetime NOT NULL DEFAULT CURRENT_TIMESTAMP,
  `updateTime` datetime DEFAULT NULL,
  PRIMARY KEY (`id`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='系统升级公告';


-- 系统升级公告与用户查看关系
CREATE TABLE `system_upgrade_user` (
  `id` bigint(22) unsigned NOT NULL AUTO_INCREMENT,
  `userId` bigint(22) DEFAULT NULL COMMENT '用户id',
  `upgradeId` bigint(22) DEFAULT NULL COMMENT '升级内容id',
  `isRead` varchar(10) DEFAULT NULL COMMENT '是否阅读：0未读 1已读',
  `readTime` datetime DEFAULT NULL COMMENT '阅读时间',
  PRIMARY KEY (`id`),
  KEY `IDX_UPGRADE_USER` (`userId`,`upgradeId`)
) ENGINE=InnoDB AUTO_INCREMENT=1 DEFAULT CHARSET=utf8mb4 COMMENT='系统升级公告与用户查看关系';

