package com.bcxin.sync.service.yehuo;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.dao.mapper.yehuo.TUserMapper;
import com.bcxin.sync.entity.yehuo.TUserEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * description：野火-用户表
 * author：linchunpeng
 * date：2025/7/14
 */
@Slf4j
@Service
public class TUserService extends ServiceImpl<TUserMapper, TUserEntity> {

    /**
     * description：通过用户id查询野火用户
     * author：linchunpeng
     * date：2025/7/14
     */
    private TUserEntity getByUserId(String userId) {
        LambdaQueryChainWrapper<TUserEntity> lqw = this.lambdaQuery();
        lqw.eq(TUserEntity::getUid, userId);
        return lqw.one();
    }

    /**
     * description：创建用户
     * author：linchunpeng
     * date：2025/7/14
     */
    @Transactional
    public void create(String userId, String name, String mobile) {
        TUserEntity entity = this.getByUserId(userId);
        if (entity == null) {
            log.info("同步野火，用户不存在，需要新建");
            entity = new TUserEntity();
            entity.setUid(userId);
            entity.setName(userId);
            entity.setDisplayName(name);
            entity.setMobile(mobile);
            entity.setDt(System.currentTimeMillis());
            this.save(entity);
        }
    }

}
