package com.bcxin.sync.service.tuoluojiang;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.dao.mapper.tuoluojiang.EbAttendanceWhitelistMapper;
import com.bcxin.sync.entity.tuoluojiang.EbAttendanceWhitelistEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

/**
 * description：陀螺匠-考勤白名单表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class EbAttendanceWhitelistService extends ServiceImpl<EbAttendanceWhitelistMapper, EbAttendanceWhitelistEntity> {

    /**
     * description：根据职员id和类型，查询考勤白名单
     * author：linchunpeng
     * date：2024/12/31
     */
    public EbAttendanceWhitelistEntity getByAdminIdAndType(Long adminId, Integer type) {
        LambdaQueryChainWrapper<EbAttendanceWhitelistEntity> lqw = this.lambdaQuery();
        lqw.eq(EbAttendanceWhitelistEntity::getUid, adminId);
        lqw.eq(EbAttendanceWhitelistEntity::getType, type);
        return lqw.one();
    }

    /**
     * description：创建考勤白名单
     * author：linchunpeng
     * date：2024/12/31
     */
    @Transactional
    public void attendanceWhitelistCreate(Long entid, Long adminId, Integer type) {
        EbAttendanceWhitelistEntity entity = this.getByAdminIdAndType(adminId, type);
        if (entity == null) {
            entity = new EbAttendanceWhitelistEntity();
            entity.setEntid(entid);
            entity.setUid(adminId);
            entity.setType(type);
            this.save(entity);
        }
    }

    /**
     * description：删除考勤白名单
     * author：linchunpeng
     * date：2024/12/31
     */
    @Transactional
    public void attendanceWhitelistDelete(Long adminId, Integer type) {
        EbAttendanceWhitelistEntity entity = this.getByAdminIdAndType(adminId, type);
        if (entity != null) {
            this.removeById(entity.getId());
        }
    }

}