package com.bcxin.sync.service.tuoluojiang;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.dao.mapper.tuoluojiang.EbAttendanceShiftMapper;
import com.bcxin.sync.entity.tuoluojiang.EbAdminEntity;
import com.bcxin.sync.entity.tuoluojiang.EbAttendanceShiftEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;

/**
 * description：陀螺匠-班次表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class EbAttendanceShiftService extends ServiceImpl<EbAttendanceShiftMapper, EbAttendanceShiftEntity> {

    @Autowired
    private EbAdminService ebAdminService;

    /**
     * description：核对初始化默认的班次
     * author：linchunpeng
     * date：2025/3/13
     */
    @Transactional
    public void checkDefaultShift(Long entid, String employeeId) {
        LambdaQueryChainWrapper<EbAttendanceShiftEntity> lqw = this.lambdaQuery();
        lqw.eq(EbAttendanceShiftEntity::getEntid, entid);
        List<EbAttendanceShiftEntity> list = lqw.list();
        boolean isNeedAddMoren = false;//是否需要增加默认
        boolean isNeedAddXiuxi = false;//是否需要增加休息
        if (CollectionUtil.isEmpty(list)) {
            //需要增加默认
            isNeedAddMoren = true;
            //需要增加休息
            isNeedAddXiuxi = true;
        } else {
            if (list.stream().noneMatch(shift -> shift.getTypes() == 2)) {
                //需要增加默认
                isNeedAddMoren = true;
            }
            if (list.stream().noneMatch(shift -> shift.getTypes() == 1)) {
                //需要增加休息
                isNeedAddXiuxi = true;
            }
        }
        if (isNeedAddMoren || isNeedAddXiuxi) {
            EbAdminEntity ebAdmin = ebAdminService.getByEmployeeId(employeeId);
            if (isNeedAddMoren) {
                //需要增加默认
                EbAttendanceShiftEntity entity = new EbAttendanceShiftEntity();
                entity.setEntid(entid);
                entity.setName("默认班次");
                entity.setNumber(1);
                entity.setRestTime(1);
                entity.setRestStart("12:00");
                entity.setRestEnd("13:00");
                entity.setRestStartAfter(0);
                entity.setRestEndAfter(0);
                entity.setOvertime(1800);
                entity.setWorkTime("8小时0分钟");
                entity.setColor("#409EFF");
                entity.setSort(100);
                entity.setUid(ebAdmin.getId());
                entity.setTypes(2);
                this.save(entity);
            }
            if (isNeedAddXiuxi) {
                //需要增加休息
                EbAttendanceShiftEntity entity = new EbAttendanceShiftEntity();
                entity.setEntid(entid);
                entity.setName("休息");
                entity.setNumber(0);
                entity.setRestTime(0);
                entity.setRestStart("00:00");
                entity.setRestEnd("00:00");
                entity.setRestStartAfter(0);
                entity.setRestEndAfter(0);
                entity.setOvertime(0);
                entity.setWorkTime("");
                entity.setColor("#CCCCCC");
                entity.setSort(100);
                entity.setUid(ebAdmin.getId());
                entity.setTypes(1);
                this.save(entity);
            }
        }
    }

}