package com.bcxin.sync.service.tuoluojiang;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.dao.mapper.tuoluojiang.EbAttendanceGroupShiftMapper;
import com.bcxin.sync.entity.tuoluojiang.EbAttendanceGroupShiftEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * description：陀螺匠-考勤组班次表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class EbAttendanceGroupShiftService extends ServiceImpl<EbAttendanceGroupShiftMapper, EbAttendanceGroupShiftEntity> {

    /**
     * description：根据考勤组id列表，获取考勤组班次
     * author：linchunpeng
     * date：2025/1/9
     */
    public List<EbAttendanceGroupShiftEntity> getByGroupId(Long groupId) {
        LambdaQueryChainWrapper<EbAttendanceGroupShiftEntity> lqw = this.lambdaQuery();
        lqw.eq(EbAttendanceGroupShiftEntity::getGroupId, groupId);
        return lqw.list();
    }

    /**
     * description：根据考勤组id列表，获取考勤组班次
     * author：linchunpeng
     * date：2025/1/9
     */
    public List<EbAttendanceGroupShiftEntity> getByGroupIdList(List<Long> groupIdList) {
        LambdaQueryChainWrapper<EbAttendanceGroupShiftEntity> lqw = this.lambdaQuery();
        lqw.in(EbAttendanceGroupShiftEntity::getGroupId, groupIdList);
        return lqw.list();
    }

}