package com.bcxin.sync.service.tuoluojiang;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.dao.mapper.tuoluojiang.EbApproveHolidayTypeMapper;
import com.bcxin.sync.entity.tuoluojiang.EbApproveHolidayTypeEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * description：陀螺匠-审批假期类型表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class EbApproveHolidayTypeService extends ServiceImpl<EbApproveHolidayTypeMapper, EbApproveHolidayTypeEntity> {

    public List<EbApproveHolidayTypeEntity> getByEntid(Long entid) {
        LambdaQueryChainWrapper<EbApproveHolidayTypeEntity> lqw = this.lambdaQuery();
        lqw.eq(EbApproveHolidayTypeEntity::getEntid, entid);
        return lqw.list();
    }

}