package com.bcxin.sync.service.tuoluojiang;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.dao.mapper.tuoluojiang.EbApproveFormMapper;
import com.bcxin.sync.entity.tuoluojiang.EbApproveFormEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * description：陀螺匠-审批表单配置表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class EbApproveFormService extends ServiceImpl<EbApproveFormMapper, EbApproveFormEntity> {

    /**
     * description：通过审批id列表，查询审批表单列表
     * author：linchunpeng
     * date：2025/3/5
     */
    public List<EbApproveFormEntity> getListByApproveIdList(List<Long> approveIdList) {
        LambdaQueryChainWrapper<EbApproveFormEntity> lqw = this.lambdaQuery();
        lqw.in(EbApproveFormEntity::getApproveId, approveIdList);
        return lqw.list();
    }

}