package com.bcxin.sync.service.tenant;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.dao.mapper.tenant.TlkEventManagerMapper;
import com.bcxin.sync.entity.tenant.TlkEventManagerEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

/**
 * description：智能人事-项目负责人表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class TlkEventManagerService extends ServiceImpl<TlkEventManagerMapper, TlkEventManagerEntity> {

    /**
     * description：判断是不是项目负责人
     * author：linchunpeng
     * date：2025/1/6
     */
    public boolean isManagerByProjectIdAndEmployeeId(String projectId, String employeeId) {
        LambdaQueryChainWrapper<TlkEventManagerEntity> lqw = this.lambdaQuery();
        lqw.eq(TlkEventManagerEntity::getItemProjectId, projectId);
        lqw.eq(TlkEventManagerEntity::getItemPersonId, employeeId);
        return lqw.exists();
    }

}