package com.bcxin.sync.service.tenant;

import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.dao.mapper.tenant.TenantUserCredentialsMapper;
import com.bcxin.sync.entity.tenant.TenantUserCredentialsEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;

import java.util.List;

/**
 * description：智能人事-用户证件表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class TenantUserCredentialsService extends ServiceImpl<TenantUserCredentialsMapper, TenantUserCredentialsEntity> {

    /**
     * description：通过智能人事用户id，查询证件列表
     * author：linchunpeng
     * date：2025/1/2
     */
    public List<TenantUserCredentialsEntity> getByTenantUserId(String tenantUserId) {
        LambdaQueryChainWrapper<TenantUserCredentialsEntity> lqw = this.lambdaQuery();
        lqw.eq(TenantUserCredentialsEntity::getTenantUserId, tenantUserId);
        return lqw.list();
    }

}