package com.bcxin.sync.service.tenant;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.configs.SyncConfig;
import com.bcxin.sync.dao.mapper.tenant.TenantEmployeesMapper;
import com.bcxin.sync.dtos.response.BcxEmployeeResponse;
import com.bcxin.sync.entity.tenant.TenantEmployeesEntity;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * description：智能人事-职员表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class TenantEmployeesService extends ServiceImpl<TenantEmployeesMapper, TenantEmployeesEntity> {

    @Autowired
    private SyncConfig syncConfig;

    /**
     * description：获取组织管理员
     * author：linchunpeng
     * date：2025/1/6
     */
    public TenantEmployeesEntity getAdminByOrgId(String orgId) {
        LambdaQueryChainWrapper<TenantEmployeesEntity> lqw = this.lambdaQuery();
        lqw.eq(TenantEmployeesEntity::getOrganizationId, orgId);
        lqw.eq(TenantEmployeesEntity::getIsDomainAdmin, 1);
        lqw.eq(TenantEmployeesEntity::getStatus, 0);
        lqw.orderByAsc(TenantEmployeesEntity::getCreatedTime);
        return lqw.list().get(0);
    }

    /**
     * description：判断是不是组织管理员
     * author：linchunpeng
     * date：2025/1/6
     */
    public boolean isAdminByOrgIdAndEmployeeId(String orgId, String employeeId) {
        LambdaQueryChainWrapper<TenantEmployeesEntity> lqw = this.lambdaQuery();
        lqw.eq(TenantEmployeesEntity::getOrganizationId, orgId);
        lqw.eq(TenantEmployeesEntity::getId, employeeId);
        lqw.eq(TenantEmployeesEntity::getIsDomainAdmin, 1);
        lqw.eq(TenantEmployeesEntity::getStatus, 0);
        return lqw.exists();
    }

    /**
     * description：获取职员列表
     * author：linchunpeng
     * date：2025/1/6
     */
    public List<TenantEmployeesEntity> getByOrgId(String orgId) {
        LambdaQueryChainWrapper<TenantEmployeesEntity> lqw = this.lambdaQuery();
        lqw.eq(TenantEmployeesEntity::getOrganizationId, orgId);
        lqw.eq(TenantEmployeesEntity::getStatus, 0);
        return lqw.list();
    }

    /**
     * description：获取组织所有员工
     * author：linchunpeng
     * date：2025/1/6
     */
    public List<BcxEmployeeResponse> getEmployeeResponseListByOrganizationId(String organizationId, Integer status) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("organizationId", organizationId);
        paramMap.put("status", status);
        if (status != null && status == 0) {
            //在职
            paramMap.put("approvedInformationStatus", 1);
        }
        return getBcxEmployeeResponseList(paramMap);
    }

    /**
     * description：根据员工id列表，获取员工
     * author：linchunpeng
     * date：2025/1/6
     */
    public List<BcxEmployeeResponse> getEmployeeResponseListByEmployeeIdList(List<String> employeeIdList, Integer status) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("idList", employeeIdList);
        paramMap.put("status", status);
        if (status != null && status == 0) {
            //在职
            paramMap.put("approvedInformationStatus", 1);
        }
        return getBcxEmployeeResponseList(paramMap);
    }

    /**
     * description：根据用户id列表，获取员工
     * author：linchunpeng
     * date：2025/1/6
     */
    public List<BcxEmployeeResponse> getEmployeeResponseListByUserIdList(List<String> userIdList, Integer status) {
        Map<String, Object> paramMap = new HashMap<>();
        paramMap.put("userIdList", userIdList);
        paramMap.put("status", status);
        if (status != null && status == 0) {
            //在职
            paramMap.put("approvedInformationStatus", 1);
        }
        return getBcxEmployeeResponseList(paramMap);
    }

    /**
     * description：获取员工列表
     * author：linchunpeng
     * date：2025/3/27
     */
    private List<BcxEmployeeResponse> getBcxEmployeeResponseList(Map<String, Object> paramMap) {
        List<BcxEmployeeResponse> list = new ArrayList<>();
        list.addAll(baseMapper.selectBcxEmployeeList(paramMap));
        list.addAll(baseMapper.selectExternalMemberList(paramMap));
        changeFileUrl(list);
        return list;
    }

    /**
     * description：视频图片地址
     * author：linchunpeng
     * date：2025/3/27
     */
    private void changeFileUrl(List<BcxEmployeeResponse> list) {
        if (CollectionUtil.isNotEmpty(list)) {
            for (BcxEmployeeResponse response : list) {
                String cardPhoto = response.getCardPhoto();
                if (StringUtils.isNotBlank(cardPhoto) && cardPhoto.startsWith("/upload")) {
                    if (cardPhoto.startsWith("/upload/")) {
                        cardPhoto = cardPhoto.replace("/upload/", "/uploads/");
                    }
                    response.setCardPhoto(syncConfig.getApiHost().getImageServer().concat(cardPhoto));
                }

                String headPhoto = response.getHeadPhoto();
                if (StringUtils.isNotBlank(headPhoto) && headPhoto.startsWith("/upload")) {
                    if (headPhoto.startsWith("/upload/")) {
                        headPhoto = headPhoto.replace("/upload/", "/uploads/");
                    }
                    response.setHeadPhoto(syncConfig.getApiHost().getImageServer().concat(headPhoto));
                }
            }
        }
    }
}