package com.bcxin.sync.service.tenant;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.dao.mapper.tenant.RbacPermitOptionUserMapper;
import com.bcxin.sync.entity.tenant.RbacPermitOptionUserEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

/**
 * description：智能人事-权限操作项用户关联表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class RbacPermitOptionUserService extends ServiceImpl<RbacPermitOptionUserMapper, RbacPermitOptionUserEntity> {

    /**
     * description：通过职员id、操作项id，判断是否存在关联关系
     * author：linchunpeng
     * date：2025/2/19
     */
    public boolean isExistPermit(String tenantEmployeeId, Long permitOptionId) {
        LambdaQueryChainWrapper<RbacPermitOptionUserEntity> lqw = this.lambdaQuery();
        lqw.eq(RbacPermitOptionUserEntity::getTenantEmployeeId, tenantEmployeeId);
        lqw.eq(RbacPermitOptionUserEntity::getPermitOptionId, permitOptionId);
        return lqw.exists();
    }

    /**
     * description：根据职员id和appcode删除
     * author：linchunpeng
     * date：2025/3/11
     */
    @Transactional
    public void deleteByTenantEmployeeIdAndAppCode(String tenantEmployeeId, String appCode) {
        LambdaQueryChainWrapper<RbacPermitOptionUserEntity> lqw = this.lambdaQuery();
        lqw.eq(RbacPermitOptionUserEntity::getTenantEmployeeId, tenantEmployeeId);
        lqw.eq(RbacPermitOptionUserEntity::getAppCode, appCode);
        List<RbacPermitOptionUserEntity> list = lqw.list();
        if (CollectionUtil.isNotEmpty(list)) {
            this.removeBatchByIds(list.stream().map(RbacPermitOptionUserEntity::getId).collect(Collectors.toList()));
        }
    }
}