package com.bcxin.sync.service.tenant;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.dao.mapper.tenant.RbacPermitAppUserMapper;
import com.bcxin.sync.entity.tenant.RbacPermitAppUserEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.stream.Collectors;

/**
 * description：智能人事-权限应用用户关联表
 * author：linchunpeng
 * date：2024/12/31
 */
@Slf4j
@Service
public class RbacPermitAppUserService extends ServiceImpl<RbacPermitAppUserMapper, RbacPermitAppUserEntity> {

    /**
     * description：根据职员id和appcode删除
     * author：linchunpeng
     * date：2025/3/11
     */
    @Transactional
    public void deleteByTenantEmployeeIdAndAppCode(String tenantEmployeeId, String appCode) {
        LambdaQueryChainWrapper<RbacPermitAppUserEntity> lqw = this.lambdaQuery();
        lqw.eq(RbacPermitAppUserEntity::getTenantEmployeeId, tenantEmployeeId);
        lqw.eq(RbacPermitAppUserEntity::getAppCode, appCode);
        List<RbacPermitAppUserEntity> list = lqw.list();
        if (CollectionUtil.isNotEmpty(list)) {
            this.removeBatchByIds(list.stream().map(RbacPermitAppUserEntity::getId).collect(Collectors.toList()));
        }
    }

}