package com.bcxin.sync.service.jvs;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.dao.mapper.jvs.SysUserTenantMapper;
import com.bcxin.sync.dtos.kafka.message.EmployeeSyncMessage;
import com.bcxin.sync.dtos.response.BcxEmployeeResponse;
import com.bcxin.sync.entity.jvs.SysUserTenantEntity;
import com.bcxin.sync.entity.tenant.TenantDepartmentEmployeeRelationsEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;
import java.util.concurrent.atomic.AtomicInteger;
import java.util.stream.Collectors;

/**
 * description：jvs-职员表
 * author：linchunpeng
 * date：2025/2/10
 */
@Slf4j
@Service
public class SysUserTenantService extends ServiceImpl<SysUserTenantMapper, SysUserTenantEntity> {

    @Autowired
    private SysUserRoleService sysUserRoleService;

    /**
     * description：批量添加员工
     * author：linchunpeng
     * date：2025/2/11
     */
    @Transactional
    public String createBatch(String orgId, List<BcxEmployeeResponse> employeeResponseList, Map<String, String> departmentMap,
                              Map<String, List<TenantDepartmentEmployeeRelationsEntity>> employeeDepartmentMap) {
        StringBuffer syncResult = new StringBuffer(256);
        AtomicInteger successAtomicCount = new AtomicInteger(0);
        log.info("批量添加员工，总数：{}", employeeResponseList.size());
        syncResult.append("\n批量添加员工，总数：").append(employeeResponseList.size());
        List<SysUserTenantEntity> list = new ArrayList<>();
        for (BcxEmployeeResponse response : employeeResponseList) {
            //执行添加员工
            try {
                list.add(this.create(orgId, response.getUserId(), response.getId(), response.getEmployeeName(), response.getTelephone(), response.getHiredDate(),
                        employeeDepartmentMap.get(response.getId()), departmentMap, null));
                successAtomicCount.incrementAndGet();
            } catch (Exception e) {
                log.error("添加员工异常，员工数据：{}，{}", JSONObject.toJSONString(response), e.getMessage(), e);
                syncResult.append("\n添加员工异常，员工数据：").append(JSONObject.toJSONString(response)).append("，").append(e);
            }
        }
        if (CollectionUtil.isNotEmpty(list)) {
            this.saveOrUpdateBatch(list);
            //初始化知识库基础用户角色
            sysUserRoleService.setUserInitRole(orgId, list.stream().map(SysUserTenantEntity::getUserId).collect(Collectors.toList()));
        }
        return syncResult.toString();
    }

    /**
     * description：添加员工
     * author：linchunpeng
     * date：2025/2/11
     */
    @Transactional
    public SysUserTenantEntity create(String orgId, String userId, String employeeId, String name, String mobile, Date hireDate,
                         List<TenantDepartmentEmployeeRelationsEntity> employeeDepartmentList,
                         Map<String, String> departmentMap, EmployeeSyncMessage employee) {
        SysUserTenantEntity entity = this.getById(employeeId);
        if (entity == null) {
            entity = new SysUserTenantEntity();
            entity.setId(employeeId);
            entity.setUserId(userId);
            entity.setEmployeeNo(employeeId);
            entity.setTenantId(orgId);
            entity.setCancelFlag(0);
        }
        entity.setRealName(name);
//        entity.setPhone(mobile);
        entity.setHireDate(hireDate);
        if (CollectionUtil.isNotEmpty(employeeDepartmentList)) {
            entity.setDeptId(employeeDepartmentList.get(0).getDepartmentId());
            entity.setDeptName(departmentMap.get(employeeDepartmentList.get(0).getDepartmentId()));
        }

        if (employee != null && employee.getBeforeStatus() != null
                && employee.getBeforeStatus().getCode() != employee.getAfterStatus().getCode()) {
            //在离职状态变化
            if (employee.getBeforeStatus().getCode() == 0 && employee.getAfterStatus().getCode() == 1) {
                //离职
                entity.setCancelFlag(1);
            } else if (employee.getBeforeStatus().getCode() == 1 && employee.getAfterStatus().getCode() == 0) {
                //复职
                entity.setCancelFlag(0);
            }
        }
        return entity;
    }

    /**
     * description：添加员工
     * author：linchunpeng
     * date：2025/2/11
     */
    @Transactional
    public void createAndSave(String orgId, String userId, String employeeId, String name, String mobile, Date hireDate,
                              List<TenantDepartmentEmployeeRelationsEntity> employeeDepartmentList,
                              Map<String, String> departmentMap, EmployeeSyncMessage employee) {
        SysUserTenantEntity entity = this.create(orgId, userId, employeeId, name, mobile, hireDate, employeeDepartmentList,
                departmentMap, employee);
        //初始化知识库基础用户角色
        sysUserRoleService.setUserInitRole(orgId, Collections.singletonList(userId));
        this.saveOrUpdate(entity);
    }

    /**
     * description：根据用户id获取职员列表
     * author：linchunpeng
     * date：2025/2/11
     */
    public List<SysUserTenantEntity> getListByUserId(String userId) {
        LambdaQueryChainWrapper<SysUserTenantEntity> lqw = this.lambdaQuery();
        lqw.eq(SysUserTenantEntity::getUserId, userId);
        return lqw.list();
    }

}