package com.bcxin.sync.service.jvs;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.dao.mapper.jvs.SysUserRoleMapper;
import com.bcxin.sync.entity.jvs.SysRoleEntity;
import com.bcxin.sync.entity.jvs.SysUserRoleEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * description：jvs-用户角色表
 * author：linchunpeng
 * date：2025/2/10
 */
@Slf4j
@Service
public class SysUserRoleService extends ServiceImpl<SysUserRoleMapper, SysUserRoleEntity> {

    @Autowired
    private SysRoleService sysRoleService;

    /**
     * description：通过角色id和用户id，查询用户角色关联
     * author：linchunpeng
     * date：2025/2/12
     */
    public List<SysUserRoleEntity> findByRoleIdAndUserId(String roleId, List<String> userIdList) {
        LambdaQueryChainWrapper<SysUserRoleEntity> lqw = this.lambdaQuery();
        lqw.eq(SysUserRoleEntity::getRoleId, roleId);
        lqw.in(SysUserRoleEntity::getUserId, userIdList);
        return lqw.list();
    }


    /**
     * description：初始化知识库的基础角色和权限
     * author：linchunpeng
     * date：2025/2/12
     */
    @Transactional
    public void setUserInitRole(String ordId, List<String> userIdList) {
        LambdaQueryChainWrapper<SysRoleEntity> lqw = sysRoleService.lambdaQuery();
        lqw.eq(SysRoleEntity::getRoleName, "知识库基本角色");
        lqw.eq(SysRoleEntity::getTenantId, ordId);
        List<SysRoleEntity> list = lqw.list();
        if (CollectionUtil.isNotEmpty(list)) {
            //取出角色
            SysRoleEntity entity = list.get(0);
            List<SysUserRoleEntity> existList = this.findByRoleIdAndUserId(entity.getId(), userIdList);
            List<String> existUserIdList = new ArrayList<>();
            if (CollectionUtil.isNotEmpty(existList)) {
                existUserIdList = existList.stream().map(SysUserRoleEntity::getUserId).collect(Collectors.toList());
            }
            for (String userId : userIdList) {
                if (!existUserIdList.contains(userId)) {
                    //新增用户角色
                    SysUserRoleEntity sysUserRoleEntity = new SysUserRoleEntity();
                    sysUserRoleEntity.setRoleId(entity.getId());
                    sysUserRoleEntity.setUserId(userId);
                    sysUserRoleEntity.setTenantId(ordId);
                    this.save(sysUserRoleEntity);
                }
            }
        }
    }

}