package com.bcxin.sync.service.jvs;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.dao.mapper.jvs.SysUserExtensionMapper;
import com.bcxin.sync.entity.jvs.SysUserExtensionEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.List;
import java.util.UUID;

/**
 * description：jvs-用户扩展信息表
 * author：linchunpeng
 * date：2025/2/10
 */
@Slf4j
@Service
public class SysUserExtensionService extends ServiceImpl<SysUserExtensionMapper, SysUserExtensionEntity> {

    /**
     * description：创建用户扩展信息表
     * author：linchunpeng
     * date：2025/2/11
     */
    @Transactional
    public void create(String userId, String name) {
        LambdaQueryChainWrapper<SysUserExtensionEntity> lqw = this.lambdaQuery();
        lqw.eq(SysUserExtensionEntity::getUserId, userId);
        lqw.eq(SysUserExtensionEntity::getOpenId, userId);
        List<SysUserExtensionEntity> list = lqw.list();
        if (CollectionUtil.isNotEmpty(list)) {
            //存在更新
            SysUserExtensionEntity entity = list.get(0);
            entity.setNickname(name);
            this.updateById(entity);
        } else {
            //不存在新增
            SysUserExtensionEntity entity = new SysUserExtensionEntity();
            entity.setId(UUID.randomUUID().toString());
            entity.setUserId(userId);
            entity.setNickname(name);
            entity.setType("bcx");
            entity.setOpenId(userId);
            this.save(entity);
        }
    }

}
