package com.bcxin.sync.service.jvs;

import cn.hutool.core.collection.CollectionUtil;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.dao.mapper.jvs.SysDeptMapper;
import com.bcxin.sync.dtos.response.BcxDepartmentResponse;
import com.bcxin.sync.entity.jvs.SysDeptEntity;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * description：jvs-部门表
 * author：linchunpeng
 * date：2025/2/10
 */
@Slf4j
@Service
public class SysDeptService extends ServiceImpl<SysDeptMapper, SysDeptEntity> {

    /**
     * description：递归创建部门
     * author：linchunpeng
     * date：2025/2/11
     */
    @Transactional
    public Map<String, String> createAll(String orgId, List<BcxDepartmentResponse> departmentTree, String parentId) {
        Map<String, String> resultMap = new HashMap<>();
        //创建下级部门
        for (BcxDepartmentResponse response : departmentTree) {
            //创建部门信息
            String deptId = this.create(orgId, response.getId(), response.getDepartmentName(), parentId);
            resultMap.put(response.getId(), response.getDepartmentName());
            if (CollectionUtil.isNotEmpty(response.getChildren()) && StringUtils.isNotBlank(deptId)) {
                resultMap.putAll(this.createAll(orgId, response.getChildren(), deptId));
            }
        }
        return resultMap;
    }

    /**
     * description：创建部门
     * author：linchunpeng
     * date：2025/2/11
     */
    @Transactional
    public String create(String orgId, String departmentId, String name, String parentId) {
        SysDeptEntity entity = this.getById(departmentId);
        if (entity == null) {
            //不存在则新增
            entity = new SysDeptEntity();
            entity.setId(departmentId);
            entity.setTenantId(orgId);
        }
        entity.setName(name);
        entity.setParentId(parentId);
        entity.setDelFlag(0);

        this.saveOrUpdate(entity);
        return entity.getId();
    }

    /**
     * description：删除部门
     * author：linchunpeng
     * date：2024/12/31
     */
    @Transactional
    public void delete(String departmentId, String departmentName) {
        SysDeptEntity entity = this.getById(departmentId);
        if (entity != null) {
            entity.setName(departmentName);
            entity.setDelFlag(-1);
            this.updateById(entity);
        }
    }

}