package com.bcxin.sync.service.datasync;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.extension.conditions.query.LambdaQueryChainWrapper;
import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.common.emus.AuthType;
import com.bcxin.sync.common.utils.IdGeneratorSnowflake;
import com.bcxin.sync.dao.mapper.datasync.ThirdPageSettingMapper;
import com.bcxin.sync.entity.datasync.ThirdPageSettingEntity;
import lombok.extern.slf4j.Slf4j;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.stream.Collectors;

/**
 * description：数据同步-第三方页面配置表
 * author：linchunpeng
 * date：2025/4/8
 */
@Slf4j
@Service
public class ThirdPageSettingService extends ServiceImpl<ThirdPageSettingMapper, ThirdPageSettingEntity> {

    @Autowired
    private IdGeneratorSnowflake snowflake;

    /**
     * description：通过页面id，查询第三方页面配置
     * author：linchunpeng
     * date：2025/4/8
     */
    public ThirdPageSettingEntity getByPageIdAndPageType(String pageId, Integer pageType) {
        LambdaQueryChainWrapper<ThirdPageSettingEntity> lqw = this.lambdaQuery();
        lqw.eq(ThirdPageSettingEntity::getPageId, pageId);
        lqw.eq(ThirdPageSettingEntity::getPageType, pageType);
        return lqw.one();
    }


    /**
     * description：通过加密后的id，查询第三方页面配置
     * author：linchunpeng
     * date：2025/4/8
     */
    public ThirdPageSettingEntity getByPageIdAndEncodeId(String pageId, String encodeId) {
        LambdaQueryChainWrapper<ThirdPageSettingEntity> lqw = this.lambdaQuery();
        lqw.eq(ThirdPageSettingEntity::getPageId, pageId);
        lqw.eq(ThirdPageSettingEntity::getEncodeId, encodeId);
        return lqw.one();
    }


    /**
     * description：设置第三方页面配置
     * author：linchunpeng
     * date：2025/4/9
     */
    public void settingThirdPage(String pageId, String pageName, Integer pageType, String pageOriginalUrl,
                                 String oldOfficePoliceIdIndex, String newOfficePoliceIdIndex) {
        ThirdPageSettingEntity thirdPageSetting = this.getByPageIdAndPageType(pageId, pageType);
        if (thirdPageSetting != null || StringUtils.isNotBlank(pageOriginalUrl)) {
            if (StringUtils.isBlank(pageOriginalUrl)) {
                //删除
                if (thirdPageSetting != null) {
                    this.removeById(thirdPageSetting.getId());
                }
            } else {
                //新增 or 修改
                boolean isNew = false;
                if (thirdPageSetting == null) {
                    thirdPageSetting = new ThirdPageSettingEntity();
                    thirdPageSetting.setId(snowflake.snowflakeId());
                    thirdPageSetting.setPageId(pageId);
                    thirdPageSetting.setPageType(pageType);
                    thirdPageSetting.setStatus(1);
                    thirdPageSetting.setAuthType(AuthType.ORG_EMP.getCode());
                    if (StringUtils.isNotBlank(newOfficePoliceIdIndex)) {
                        //新增的时候，直接存监管机构
                        thirdPageSetting.setAuthOrgIds(newOfficePoliceIdIndex.replace("___", ";"));
                    }
                    isNew = true;
                }
                thirdPageSetting.setPageName(pageName);
                if (StringUtils.isNotBlank(pageOriginalUrl)) {
                    if (pageOriginalUrl.contains("[{")) {
                        pageOriginalUrl = JSONObject.parseArray(pageOriginalUrl, JSONObject.class).get(0).getString("path");
                    }
                    //目前没有加密，直接最后一个
                    thirdPageSetting.setEncodeId(pageOriginalUrl.substring(pageOriginalUrl.lastIndexOf("/")+1));
                } else {
                    thirdPageSetting.setEncodeId(pageOriginalUrl);
                }
                thirdPageSetting.setPageOriginalUrl(pageOriginalUrl);

                if (isNew) {
                    this.save(thirdPageSetting);
                } else {
                    if (!oldOfficePoliceIdIndex.equals(newOfficePoliceIdIndex)) {
                        //监管机构有变更
                        List<String> authOrgIds = new ArrayList<>();
                        if (StringUtils.isNotBlank(thirdPageSetting.getAuthOrgIds())) {
                            //旧的授权组织列表
                            authOrgIds = Arrays.stream(thirdPageSetting.getAuthOrgIds().split("___")).collect(Collectors.toList());
                        }
                        if (StringUtils.isNotBlank(oldOfficePoliceIdIndex)) {
                            //先移除旧的监管机构
                            for (String orgId : oldOfficePoliceIdIndex.split("___")) {
                                authOrgIds.remove(orgId);
                            }
                        }
                        if (StringUtils.isNotBlank(newOfficePoliceIdIndex)) {
                            //再加新的监管机构
                            for (String orgId : newOfficePoliceIdIndex.split("___")) {
                                if (!authOrgIds.contains(orgId)) {
                                    authOrgIds.add(orgId);
                                }
                            }
                        }
                        thirdPageSetting.setAuthOrgIds(String.join(";", authOrgIds));
                    }
                    this.updateById(thirdPageSetting);
                }
            }
        }
    }

}