package com.bcxin.sync.service.datasync;

import com.baomidou.mybatisplus.extension.service.impl.ServiceImpl;
import com.bcxin.sync.common.utils.IdGeneratorSnowflake;
import com.bcxin.sync.dao.mapper.datasync.OrganizationOpenLogMapper;
import com.bcxin.sync.dtos.request.OrganizationOpenRequest;
import com.bcxin.sync.entity.datasync.OrganizationOpenLogEntity;
import lombok.extern.slf4j.Slf4j;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.Date;

/**
 * description：数据同步-企业开通日志表服务层
 * author：linchunpeng
 * date：2025/1/17
 */
@Slf4j
@Service
public class OrganizationOpenLogService extends ServiceImpl<OrganizationOpenLogMapper, OrganizationOpenLogEntity> {

    @Autowired
    private IdGeneratorSnowflake snowflake;

    /**
     * description：创建日志
     * author：linchunpeng
     * date：2025/1/17
     */
    @Transactional
    public void createLog(OrganizationOpenRequest request) {
        OrganizationOpenLogEntity entity = new OrganizationOpenLogEntity();
        entity.setId(snowflake.snowflakeId());
        entity.setOrganizationId(request.getOrganizationId());
        entity.setOrganizationName(request.getOrganizationName());
        entity.setOpenType(request.getOpenType());
        entity.setOpenTime(new Date());
        entity.setOpenDay(request.getOpenDay());
        this.save(entity);
    }

    /**
     * description：创建日志
     * author：linchunpeng
     * date：2025/1/17
     */
    @Transactional
    public void createLog(String organizationId, String organizationName, Integer openType, Integer openDay) {
        OrganizationOpenLogEntity entity = new OrganizationOpenLogEntity();
        entity.setId(snowflake.snowflakeId());
        entity.setOrganizationId(organizationId);
        entity.setOrganizationName(organizationName);
        entity.setOpenType(openType);
        entity.setOpenTime(new Date());
        entity.setOpenDay(openDay);
        this.save(entity);
    }
}