package com.bcxin.sync.entity.tuoluojiang;

import com.baomidou.mybatisplus.annotation.IdType;
import com.baomidou.mybatisplus.annotation.TableId;
import com.baomidou.mybatisplus.annotation.TableName;
import lombok.Data;

import java.io.Serializable;

/**
 * description：陀螺匠-班次表
 * author：linchunpeng
 * date：2024/12/31
 */
@Data
@TableName("eb_attendance_shift")
public class EbAttendanceShiftEntity implements Serializable {

    private static final long serialVersionUID = 1L;

    //主键id
    @TableId(value = "id", type = IdType.AUTO)
    private Long id;

    //企业表id
    private Long entid;

    //班次名称
    private String name;

    //上下班次数 0、休息；1、1次上下班；2、2次上下班；
    private Integer number;

    //中途休息：1、开启；0、关闭；
    private Integer restTime;

    //休息开始时间
    private String restStart;

    //休息结束时间
    private String restEnd;

    //休息开始规则 0、当日；1、次日；
    private Integer restStartAfter;

    //休息结束规则 0、当日；1、次日；
    private Integer restEndAfter;

    //加班起算时间
    private Integer overtime;

    //工作时长
    private String workTime;

    //颜色标识
    private String color;

    //排序
    private Integer sort;

    //业务员ID
    private Long uid;

    //班次类型：0、正常；1、休息；2、默认
    private Integer types;

}