package com.bcxin.sync.dtos.response;

import cn.hutool.core.collection.CollectionUtil;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.sync.entity.tenant.TenantDepartmentEmployeeRelationsEntity;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.ArrayList;
import java.util.Date;
import java.util.List;


@Data
public class BcxEmployeeResponse {

    //员工id
    private String id;

    //用户id
    private String userId;

    //手机号
    private String telephone;

    //员工姓名
    private String employeeName;

    //证件号
    private String credentialNumber;

    //身份证头像
    private String cardPhoto;

    //身份证头像
    private String headPhoto;

    //入职日期
    private Date hiredDate;

    //是否组织管理员
    private Integer isDomainAdmin;

    //组织id
    private String organizationId;

    //外部组id json
    private String groupIdsJson;


    /**
     * description：获取组和成员的关联关系
     * author：linchunpeng
     * date：2025/3/27
     */
    public List<TenantDepartmentEmployeeRelationsEntity> getGroupMemberRelationList() {
        if (StringUtils.isBlank(groupIdsJson)) {
            return null;
        }
        List<String> groupIdList = JSONObject.parseArray(groupIdsJson, String.class);
        if (CollectionUtil.isEmpty(groupIdList)) {
            return null;
        }
        List<TenantDepartmentEmployeeRelationsEntity> list = new ArrayList<>();
        for (String groupId : groupIdList) {
            TenantDepartmentEmployeeRelationsEntity relation = new TenantDepartmentEmployeeRelationsEntity();
            relation.setId(this.getId().concat("-").concat(groupId));
            relation.setDepartmentId(groupId);
            relation.setEmployeeId(this.getId());
            relation.setLeaderType(0);
            list.add(relation);
        }
        return list;
    }

}
