package com.bcxin.sync.dtos.kafka.record;

import lombok.Data;

import java.math.BigDecimal;
import java.util.Date;

/**
 * 驻勤点kafka记录
 */
@Data
public class AttendanceSiteKafkaRecord {
    private AttendanceSiteRecord before;
    private AttendanceSiteRecord after;

    @Data
    public class AttendanceSiteRecord {
        //主键id
        private String id;
        //组织id
        private String domainid;
        //驻勤点名称
        private String item_attendanceSiteName;
        //驻勤点详细地址
        private String item_attendanceSiteFullAddress;
        //驻勤点经度
        private BigDecimal item_attendanceSiteLongitude;
        //驻勤点纬度
        private BigDecimal item_attendanceSiteLatitude;
        //执行范围
        private BigDecimal item_performRange;
        //驻勤点状态,已完善
        private String item_attendanceSiteState;
        //驻勤开始日期
        private Date item_attendanceStartDate;
        //驻勤结束日期
        private Date item_attendanceEndDate;
        //负责人，职员id
        private String item_principal;
        //驻勤点类型，0或空：常驻，其他：临保
        private String item_att_type;
    }
}
