package com.bcxin.sync.dtos.kafka.message;

import com.bcxin.sync.common.emus.DataOperationType;
import lombok.Data;
import org.apache.commons.lang3.StringUtils;

import java.util.Date;

/**
 * 团队项目变更信息
 */
@Data
public class TlkEventProjectSyncMessage {
    private String id;
    private String name;
    private String domainId;
    private String domainName;
    private Date endTime;
    private String link3d;
    private String assesmentReport;
    private String beforeOfficePoliceIdIndex;
    private String afterOfficePoliceIdIndex;
    private DataOperationType opType;

    public String getBeforeOfficePoliceIdIndex() {
        return StringUtils.isNotBlank(beforeOfficePoliceIdIndex) ? beforeOfficePoliceIdIndex : "";
    }

    public String getAfterOfficePoliceIdIndex() {
        return StringUtils.isNotBlank(afterOfficePoliceIdIndex) ? afterOfficePoliceIdIndex : "";
    }
}
