package com.bcxin.sync.consumer;

import com.alibaba.fastjson.JSONObject;
import com.bcxin.sync.common.CommonConstant;
import com.bcxin.sync.common.utils.KafkaMessageUtil;
import com.bcxin.sync.dtos.kafka.message.TenantOrganizationsSyncMessage;
import com.bcxin.sync.dtos.request.OrganizationOpenRequest;
import com.bcxin.sync.service.RedisCache;
import com.bcxin.sync.service.datasync.OrganizationOpenService;
import com.bcxin.sync.service.tenant.RbacCustomRoleService;
import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Service;

/**
 * 组织kafka消息监听器
 */
@Slf4j
@Service
public class TenantOrganizationsKafkaConsumer {

    @Autowired
    private RbacCustomRoleService rbacCustomRoleService;
    @Autowired
    private OrganizationOpenService organizationOpenService;

    @Autowired
    private RedisCache redisCache;

    @KafkaListener(id = "bcx_data_sync_listener_tenant_organizations",
            topics = CommonConstant.TENANT_ORGANIZATIONS_KAFKA_TOPIC,
            groupId = "bcx_data_sync_tenant_organizations")
    public void bcxDataSyncTenantOrganizations(ConsumerRecord<String, String> record, Acknowledgment ack) {
        TenantOrganizationsSyncMessage organizations = KafkaMessageUtil.transferKafkaOrganizationsRecord2Message(record);
        log.info("kafka监听tenant-organizations表，数据转化为：{}", JSONObject.toJSONString(organizations));
        try {
            if (organizations != null
                    && organizations.getBeforeLevel() != null && organizations.getBeforeLevel() == 1
                    && organizations.getAfterLevel() != null && organizations.getAfterLevel() == 2) {
                //普通版升级高级版
                //清除level缓存
                String key = "data-sync:org:level:" + organizations.getOrganizationId();
                redisCache.deleteObject(key);
                //初始化"普通员工"角色
                rbacCustomRoleService.initRole(organizations.getOrganizationId());
                //初始化用户权限(升级高级版之前的权限同步到高级版)
                rbacCustomRoleService.initUserPermit(organizations.getOrganizationId());
                //开通陀螺匠
                OrganizationOpenRequest request = new OrganizationOpenRequest();
                request.setOrganizationId(organizations.getOrganizationId());
                request.setOrganizationName(organizations.getAfterName());
                request.setOpenType(1);
                request.setOpenDay(7300);
                organizationOpenService.openThird(request);
            } else {
                log.info("组织不是高级版，无需初始化<普通员工>角色");
            }
        } catch (Exception e) {
            log.error("kafka监听tenant-organizations表，异常：{}", e.getMessage(), e);
        }
        ack.acknowledge();
    }
}
