package com.bcxin.sync.consumer;

import cn.hutool.core.collection.ListUtil;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.sync.common.CommonConstant;
import com.bcxin.sync.common.emus.DataOperationType;
import com.bcxin.sync.common.utils.KafkaMessageUtil;
import com.bcxin.sync.dtos.kafka.message.EbEnterpriseMessageNoticeSyncMessage;
import com.bcxin.sync.dtos.tenant.McNoticeContentDto;
import com.bcxin.sync.dtos.tenant.McNoticeLinkParamsDto;
import com.bcxin.sync.entity.tenant.McNoticeEntity;
import com.bcxin.sync.entity.tuoluojiang.EbAdminEntity;
import com.bcxin.sync.entity.tuoluojiang.EbEnterpriseEntity;
import com.bcxin.sync.service.tenant.McNoticeService;
import com.bcxin.sync.service.tuoluojiang.EbAdminService;
import com.bcxin.sync.service.tuoluojiang.EbEnterpriseService;
import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Service;

import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.UUID;

/**
 * 陀螺匠消息通知kafka监听器
 */
@Slf4j
@Service
public class EbEnterpriseMessageNoticeKakfaConsumer {

    @Autowired
    private EbEnterpriseService ebEnterpriseService;
    @Autowired
    private EbAdminService ebAdminService;
    @Autowired
    private McNoticeService mcNoticeService;

    private static final List<Long> NEED_SYNC_NOTICE_CATE_ID = ListUtil.of(97L, 78L);
    private static final Map<Long, String> SUBJECT_TYPE_APP_CODE = new HashMap<>();
    static {
        SUBJECT_TYPE_APP_CODE.put(97L, "__yXF3gCR1rLDkGP9l3Vm");
        SUBJECT_TYPE_APP_CODE.put(78L, "__nxvdMJ82R9ZsXae3UGL");
    }

    @KafkaListener(id = "bcx_data_sync_listener_eb_enterprise_message_notice_to_v5",
            topics = CommonConstant.EB_ENTERPRISE_MESSAGE_NOTICE_KAFKA_TOPIC,
            groupId = "bcx_data_sync_eb_enterprise_message_notice_to_v5")
    public void bcxDataSyncEbEnterpriseMessageNoticeToV5(ConsumerRecord<String, String> record, Acknowledgment ack) {
        EbEnterpriseMessageNoticeSyncMessage notice = KafkaMessageUtil.transferKafkaEbEnterpriseMessageNoticeRecord2Message(record);
        log.info("kafka监听eb_enterprise_message_notice表，数据转化为：{}", JSONObject.toJSONString(notice));
        try {
            if (notice.getType().getCode() == DataOperationType.CREATE.getCode()
                    && notice.getCateId() != null
                    && NEED_SYNC_NOTICE_CATE_ID.contains(notice.getCateId())) {
                log.info("陀螺匠有新增消息通知，消息类型：{}", notice.getCateName());
                EbAdminEntity adminEntity = ebAdminService.getById(notice.getAdminId());
                EbEnterpriseEntity enterpriseEntity = ebEnterpriseService.getById(adminEntity.getEntid());

                McNoticeEntity mcNoticeEntity = new McNoticeEntity();
                mcNoticeEntity.setId(UUID.randomUUID().toString());
                mcNoticeEntity.setIsRead(0);
                mcNoticeEntity.setToUserId(adminEntity.getUniqued());
                mcNoticeEntity.setCreateTime(notice.getCreatedAt());
                mcNoticeEntity.setDomainId(enterpriseEntity.getUniqued());
                mcNoticeEntity.setModule(notice.getCateName());
                mcNoticeEntity.setSubjectType(notice.getCateId().intValue());

                McNoticeLinkParamsDto linkParamsDto = new McNoticeLinkParamsDto(SUBJECT_TYPE_APP_CODE.get(notice.getCateId()));
                mcNoticeEntity.setLinkParams(JSONObject.toJSONString(linkParamsDto));

                McNoticeContentDto contentDto = new McNoticeContentDto(adminEntity.getUid(), adminEntity.getName(),
                        enterpriseEntity.getUniqued(), adminEntity.getUniqued(), notice.getCateId().intValue(),
                        notice.getCateName(), notice.getTitle(), notice.getMessage(), notice.getCreatedAt());
                mcNoticeEntity.setContent(JSONObject.toJSONString(contentDto));

                String summary = String.format("<span class='notice_type' type='%s'></span><span class='notice_summary'>%s</span>",
                        contentDto.getType(), contentDto.getContent());
                mcNoticeEntity.setSummary(summary);

                mcNoticeService.save(mcNoticeEntity);
            } else {
                log.info("其他类型消息不同步");
            }
        } catch (Exception e) {
            log.error("kafka监听eb_enterprise_message_notice表，异常：{}", e.getMessage(), e);
        }
        ack.acknowledge();
    }
}
