package com.bcxin.sync.consumer;

import cn.hutool.core.collection.CollectionUtil;
import cn.hutool.core.date.DateUtil;
import com.alibaba.fastjson.JSONObject;
import com.bcxin.sync.common.CommonConstant;
import com.bcxin.sync.common.emus.DataOperationType;
import com.bcxin.sync.common.emus.OpenType;
import com.bcxin.sync.common.utils.CommonUtils;
import com.bcxin.sync.common.utils.KafkaMessageUtil;
import com.bcxin.sync.dtos.kafka.message.AttendanceSitePersonSyncMessage;
import com.bcxin.sync.dtos.response.BcxEmployeeResponse;
import com.bcxin.sync.entity.tenant.TlkAttendanceSiteBaseInfoEntity;
import com.bcxin.sync.entity.tuoluojiang.EbAdminEntity;
import com.bcxin.sync.entity.tuoluojiang.EbAdminInfoEntity;
import com.bcxin.sync.entity.tuoluojiang.EbUserEntity;
import com.bcxin.sync.service.datasync.OrganizationOpenService;
import com.bcxin.sync.service.tenant.TenantEmployeesService;
import com.bcxin.sync.service.tenant.TlkAttendanceSiteBaseInfoService;
import com.bcxin.sync.service.tuoluojiang.*;
import lombok.extern.slf4j.Slf4j;
import org.apache.kafka.clients.consumer.ConsumerRecord;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.kafka.annotation.KafkaListener;
import org.springframework.kafka.support.Acknowledgment;
import org.springframework.stereotype.Component;

import java.util.Collections;
import java.util.Date;
import java.util.List;

/**
 * 驻勤人员kafka监听器
 */
@Slf4j
@Component
public class AttendanceSitePersonKakfaConsumer {

    @Autowired
    private EbUserService ebUserService;
    @Autowired
    private EbAdminInfoService ebAdminInfoService;
    @Autowired
    private EbFrameAssistService ebFrameAssistService;
    @Autowired
    private EbAttendanceGroupMemberService ebAttendanceGroupMemberService;
    @Autowired
    private EbAttendanceGroupService ebAttendanceGroupService;
    @Autowired
    private EbEnterpriseService ebEnterpriseService;
    @Autowired
    private EbAdminService ebAdminService;
    @Autowired
    private EbEnterpriseRoleService ebEnterpriseRoleService;
    @Autowired
    private OrganizationOpenService organizationOpenService;
    @Autowired
    private TlkAttendanceSiteBaseInfoService tlkAttendanceSiteBaseInfoService;
    @Autowired
    private TenantEmployeesService tenantEmployeesService;

    @KafkaListener(id = "bcx_data_sync_listener_attendance_site_person_to_tlj",
            topics = CommonConstant.ATTENDANCESITE_PERSON_KAFKA_TOPIC,
            groupId = "bcx_data_sync_attendance_site_person_to_tlj")
    public void bcxDataSyncAttendanceSitePersonToTlj(ConsumerRecord<String, String> record, Acknowledgment ack) {
        AttendanceSitePersonSyncMessage attSitePerson = KafkaMessageUtil.transferKafkaAttSitePersonRecord2Message(record);
        log.info("kafka监听tlk_attendance_site_person_info表，数据转化为：{}", JSONObject.toJSONString(attSitePerson));
        try {
            boolean openAndEffective = organizationOpenService.isOpenAndEffective(attSitePerson.getOrganizationId(), OpenType.TLJ.getCode());
            if (openAndEffective) {
                Long entid = ebEnterpriseService.getIdByOrgId(attSitePerson.getOrganizationId());
                if (entid != null) {
                    log.info("组织id：{}，有开通陀螺匠，所以需要同步驻勤人员信息", attSitePerson.getOrganizationId());
                    Long groupId = ebAttendanceGroupService.getIdByAttendanceSiteId(attSitePerson.getAttSiteId());
                    if (groupId == null) {
                        TlkAttendanceSiteBaseInfoEntity attendanceSiteBaseInfo = tlkAttendanceSiteBaseInfoService.getById(attSitePerson.getAttSiteId());
                        groupId = ebAttendanceGroupService.attendanceGroupCreate(entid, attendanceSiteBaseInfo.getId(),
                                attendanceSiteBaseInfo.getItemAttendanceSiteName(), attendanceSiteBaseInfo.getItemAttendanceSiteFullAddress(),
                                attendanceSiteBaseInfo.getItemAttendanceSiteLongitude(), attendanceSiteBaseInfo.getItemAttendanceSiteLatitude(),
                                attendanceSiteBaseInfo.getItemPerformRange(), attendanceSiteBaseInfo.getItemPrincipal(),
                                attendanceSiteBaseInfo.getItemAttType());
                    }
                    String itemAttType = tlkAttendanceSiteBaseInfoService.getItemAttType(attSitePerson.getAttSiteId());
                    Long adminId = ebAdminService.getIdByEmployeeId(attSitePerson.getEmployeeId(), entid);
                    if (adminId == null) {
                        if (CommonUtils.isLinBao(itemAttType)) {
                            log.info("组织id：{}，有开通陀螺匠，并且是临保项目，同步驻勤人员信息，人员是外部企业人员", attSitePerson.getOrganizationId());
                            List<BcxEmployeeResponse> employeeResponseList = tenantEmployeesService.getEmployeeResponseListByEmployeeIdList(Collections.singletonList(attSitePerson.getEmployeeId()), 0);
                            if (CollectionUtil.isNotEmpty(employeeResponseList)) {
                                BcxEmployeeResponse outEmployee = employeeResponseList.get(0);
                                EbUserEntity ebUserEntity = ebUserService.getUserByUserId(outEmployee.getUserId());
                                String employeeId = outEmployee.getUserId() + "_" + attSitePerson.getOrganizationId();
                                if (ebUserEntity == null) {
                                    log.info("同步陀螺匠，职员id：{}，同步驻勤人员信息，人员是外部企业人员,还未同步过陀螺匠，所以需要同步用户信息", employeeId);
                                    ebUserService.userCreate(outEmployee.getUserId(), outEmployee.getCredentialNumber(),
                                            outEmployee.getCardPhoto(), outEmployee.getHeadPhoto(),
                                            outEmployee.getEmployeeName(), outEmployee.getTelephone());
                                }
                                Long oaAndAttendanceRoleId = ebEnterpriseRoleService.createGetOaAndAttendanceRole(entid);
                                ebAdminService.userJoin(attSitePerson.getOrganizationId(), entid, outEmployee.getUserId(), employeeId,
                                        null, null, null);
                                //同步员工其他信息
                                EbAdminEntity ebAdminEntity = ebAdminService.setAdminOtherInfo(employeeId, oaAndAttendanceRoleId, outEmployee.getCardPhoto(), null, 0, 1);
                                if (ebAdminEntity != null) {
                                    adminId = ebAdminEntity.getId();
                                }
                            }
                        }
                    }
                    if (adminId != null && groupId != null) {
                        if (attSitePerson.getType().getCode() == DataOperationType.CREATE.getCode()) {
                            log.info("组织id：{}，新增驻勤人员", attSitePerson.getOrganizationId());
                            if (CommonUtils.isLinBao(itemAttType)) {
                                //临保，且报到了 或 推送到考勤，需要额外处理，如果有在其他考勤组，需要设置排除考勤成员
                                if (attSitePerson.getReportingTime() != null
                                        || (attSitePerson.getPushAttendance() != null && attSitePerson.getPushAttendance() == 1)) {
                                    ebAttendanceGroupMemberService.addMemberExclude(entid, groupId, adminId);
                                    ebAttendanceGroupMemberService.addMember(entid, groupId, adminId, 0, true);

                                    EbAdminEntity adminEntity = ebAdminService.getById(adminId);
                                    EbAdminInfoEntity adminInfoEntity = ebAdminInfoService.getByUserIdAndEntid(adminEntity.getUid(), entid);
                                    if (adminInfoEntity != null && adminInfoEntity.getType() != 1) {
                                        //如果是离职需要改为在职
                                        adminInfoEntity.setType(1);
                                        adminInfoEntity.setWorkTime(DateUtil.formatDateTime(new Date()));
                                        ebAdminInfoService.updateById(adminInfoEntity);
                                    }
                                }
                            } else {
                                //常保，直接加入考勤组
                                ebAttendanceGroupMemberService.addMember(entid, groupId, adminId, 0, true);
                            }
                        } else if (attSitePerson.getType().getCode() == DataOperationType.DELETE.getCode()) {
                            log.info("组织id：{}，删除了驻勤人员", attSitePerson.getOrganizationId());
                            ebAttendanceGroupMemberService.deleteMember(entid, groupId, adminId, 0);
                            if (CommonUtils.isLinBao(itemAttType)) {
                                //临保，需要额外处理，如果有在其他考勤组的排除考勤成员里面，需要删除
                                ebAttendanceGroupMemberService.deleteMemberExclude(Collections.singletonList(adminId));

                                EbAdminEntity adminEntity = ebAdminService.getById(adminId);
                                EbAdminInfoEntity adminInfoEntity = ebAdminInfoService.getByUserIdAndEntid(adminEntity.getUid(), entid);
                                if (adminInfoEntity != null && adminInfoEntity.getIsPart() == 1 && adminInfoEntity.getType() != 4) {
                                    //外部企业人员，如果是在职需要改为离职
                                    adminInfoEntity.setType(4);
                                    adminInfoEntity.setQuitTime(DateUtil.formatDateTime(new Date()));
                                    ebAdminInfoService.updateById(adminInfoEntity);

                                    //删除部门人员关联
                                    ebFrameAssistService.frameAssistDelete(entid, adminEntity.getId());
                                }
                            }
                        }
                    }
                }
            } else {
                log.info("组织id：{}，没开通陀螺匠，所以不需要同步驻勤人员信息", attSitePerson.getOrganizationId());
            }
        } catch (Exception e) {
            log.error("kafka监听tlk_attendance_site_person_info表，异常：{}", e.getMessage(), e);
        }
        ack.acknowledge();
    }
}
