package com.bcxin.sync.common.utils;


/**
 * description：时间戳管理类 - 解决时间戳不一致问题
 * author：linchunpeng
 * date：2025/6/11
 */
public class TimestampManager {

    private final long frameInterval;
    private long videoTimestamp = 0;
    private long audioTimestamp = 0;

    public TimestampManager(double frameRate) {
        // 计算每帧间隔（微秒）
        this.frameInterval = (long)(1000000 / frameRate);
    }

    public long getNextVideoTimestamp() {
        videoTimestamp += frameInterval;
        return videoTimestamp;
    }

    public long getNextAudioTimestamp(int sampleRate) {
        // 计算采样间隔
        long samplesPerFrame = 1024; // 典型每帧样本数
        long sampleInterval = (samplesPerFrame * 1000000L) / sampleRate;

        audioTimestamp += sampleInterval;
        return audioTimestamp;
    }

    public void reset() {
        videoTimestamp -= frameInterval;
    }
}
