package com.bcxin.sync.common.utils;

import cn.hutool.core.collection.CollectionUtil;
import com.bcxin.sync.common.CommonConstant;
import org.apache.http.client.methods.*;
import org.apache.http.conn.ssl.NoopHostnameVerifier;
import org.apache.http.entity.StringEntity;
import org.apache.http.impl.client.CloseableHttpClient;
import org.apache.http.impl.client.HttpClients;
import org.apache.http.ssl.SSLContextBuilder;
import org.apache.http.util.EntityUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import javax.net.ssl.SSLContext;
import javax.net.ssl.TrustManager;
import javax.net.ssl.X509TrustManager;
import java.io.IOException;
import java.security.KeyManagementException;
import java.security.KeyStoreException;
import java.security.NoSuchAlgorithmException;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.UUID;

/**
 * description: http 请求工具类
 * author: linchunpeng
 * date:  2023-04-18 9:54
 */
public class HttpUtil {

    private static final Logger logger = LoggerFactory.getLogger(HttpUtil.class);

    /**
     * description: http post请求
     * author: linchunpeng
     * date:  2023-04-18 9:54
     */
    public static String post(String url, String bodyJson) {
        return post(url, bodyJson, null, false);
    }
    /**
     * description: http post请求
     * author: linchunpeng
     * date:  2023-04-18 9:54
     */
    public static String post(String url, String bodyJson, Map<String, String> headerMap, boolean isSkipSsl) {
        String postId = UUID.randomUUID().toString();
        logger.info("=====================http post 请求=====================");
        logger.info("postId：" + postId);
        logger.info("请求地址：" + url);
        logger.info("请求参数：" + bodyJson);
        logger.info("=======================================================");
        String result = "";

        // 创建一个httpclient对象
        CloseableHttpClient client = null;
//        if (isSkipSsl) {
            // 创建信任所有证书的TrustManager
            TrustManager[] trustAllCerts = new TrustManager[]{
                    new X509TrustManager() {
                        public void checkClientTrusted(X509Certificate[] chain, String authType) {}
                        public void checkServerTrusted(X509Certificate[] chain, String authType) {}
                        public X509Certificate[] getAcceptedIssuers() { return new X509Certificate[0]; }
                    }
            };
            // 初始化SSLContext
            try {
                SSLContext sslContext = SSLContextBuilder.create()
                        .loadTrustMaterial(null, (chain, authType) -> true)
                        .build();
                client = HttpClients.custom()
                        .setSSLContext(sslContext)
                        .setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE)
                        .build();
            } catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            } catch (KeyManagementException e) {
                e.printStackTrace();
            } catch (KeyStoreException e) {
                e.printStackTrace();
            }
//        }
        if (client == null) {
            client = HttpClients.createDefault();
        }
        // 创建一个post对象
        HttpPost post = new HttpPost(url);
        CloseableHttpResponse response = null;
        try {
            // 设置请求的内容
            post.setEntity(new StringEntity(bodyJson, "utf-8"));
            // 设置请求的报文头部的编码
            post.addHeader("Content-Type", "application/json;charset=utf-8");
            if (CollectionUtil.isNotEmpty(headerMap)) {
                for (Map.Entry<String, String> header : headerMap.entrySet()) {
                    post.addHeader(header.getKey(), header.getValue());
                }
            }
            // 执行post请求
            response = client.execute(post);
            // 获取响应码
            int statusCode = response.getStatusLine().getStatusCode();
            result = EntityUtils.toString(response.getEntity());
            logger.info("postId：{}, 请求参数结果：{}", postId, result);
            if (statusCode != 200) {
                result = CommonConstant.HTTP_REQUEST_FAIL_RESULT;
                logger.error("调用接口请求失败,错误码为：" + statusCode);
                post.abort();
            }
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("调用接口请求失败：" + e.getMessage(), e);
            result = CommonConstant.HTTP_REQUEST_FAIL_RESULT;
            post.abort();
        } finally {
            if (response != null) {
                try {
                    response.close();
                    post.abort();
                } catch (IOException e) {
                    e.printStackTrace();
                    logger.error("关闭接口response出错：" + e.getMessage(), e);
                }
            }
            try {
                client.close();
                post.abort();
            } catch (IOException e) {
                e.printStackTrace();
                logger.error("关闭http接口client出错：" + e.getMessage(), e);
            }
        }
        logger.info("=====================http post 请求结果=====================");
        logger.info("postId：" + postId);
        logger.info("请求结果：" + result);
        logger.info("=======================================================");
        return result;
    }

    /**
     * description: http get请求
     * author: linchunpeng
     * date:  2023-04-18 9:55
     */
    public static String get(String url, Map<String, String> headerMap, boolean isSkipSsl) {
        String getId = UUID.randomUUID().toString();
        logger.info("=====================http get 请求=====================");
        logger.info("getId：" + getId);
        logger.info("请求地址：" + url);
        logger.info("=======================================================");
        String result = "";
        // 创建一个httpclient对象
        CloseableHttpClient client = null;
//        if (isSkipSsl) {
            // 创建信任所有证书的TrustManager
            TrustManager[] trustAllCerts = new TrustManager[]{
                    new X509TrustManager() {
                        public void checkClientTrusted(X509Certificate[] chain, String authType) {}
                        public void checkServerTrusted(X509Certificate[] chain, String authType) {}
                        public X509Certificate[] getAcceptedIssuers() { return new X509Certificate[0]; }
                    }
            };
            // 初始化SSLContext
            try {
                SSLContext sslContext = SSLContextBuilder.create()
                        .loadTrustMaterial(null, (chain, authType) -> true)
                        .build();
                client = HttpClients.custom()
                        .setSSLContext(sslContext)
                        .setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE)
                        .build();
            } catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            } catch (KeyManagementException e) {
                e.printStackTrace();
            } catch (KeyStoreException e) {
                e.printStackTrace();
            }
//        }
        if (client == null) {
            client = HttpClients.createDefault();
        }
        // 创建一个post对象
        HttpGet get = new HttpGet(url);
        CloseableHttpResponse response = null;
        try {
            // 设置请求的报文头部的编码
            if (CollectionUtil.isNotEmpty(headerMap)) {
                for (Map.Entry<String, String> header : headerMap.entrySet()) {
                    get.addHeader(header.getKey(), header.getValue());
                }
            } else {
                get.addHeader("Content-Type", "application/json;charset=utf-8");
            }
            // 执行get请求
            response = client.execute(get);
            result = EntityUtils.toString(response.getEntity());
            logger.info("getId：{}, 请求参数结果：{}", getId, result);
            // 获取响应码
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                result = CommonConstant.HTTP_REQUEST_FAIL_RESULT;
                logger.error("调用接口请求失败,错误码为：" + statusCode);
                get.abort();
            }
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("调用接口请求失败：" + e.getMessage(), e);
            result = CommonConstant.HTTP_REQUEST_FAIL_RESULT;
            get.abort();
        } finally {
            if (response != null) {
                try {
                    response.close();
                    get.abort();
                } catch (IOException e) {
                    e.printStackTrace();
                    logger.error("关闭接口response出错：" + e.getMessage(), e);
                }
            }
            try {
                client.close();
                get.abort();
            } catch (IOException e) {
                e.printStackTrace();
                logger.error("关闭http接口client出错：" + e.getMessage(), e);
            }
        }
        logger.info("=====================http get 请求结果=====================");
        logger.info("getId：" + getId);
//        logger.info("请求结果：" + result);
        logger.info("=======================================================");
        return result;
    }

    /**
     * http delete请求
     */
    public static String delete(String url, Map<String, String> headerMap, boolean isSkipSsl) {
        String deleteId = UUID.randomUUID().toString();
        logger.info("=====================http delete 请求=====================");
        logger.info("deleteId：" + deleteId);
        logger.info("请求地址：" + url);
        logger.info("=======================================================");
        String result = "";
        // 创建一个httpclient对象
        CloseableHttpClient client = null;
//        if (isSkipSsl) {
            // 创建信任所有证书的TrustManager
            TrustManager[] trustAllCerts = new TrustManager[]{
                    new X509TrustManager() {
                        public void checkClientTrusted(X509Certificate[] chain, String authType) {}
                        public void checkServerTrusted(X509Certificate[] chain, String authType) {}
                        public X509Certificate[] getAcceptedIssuers() { return new X509Certificate[0]; }
                    }
            };
            // 初始化SSLContext
            try {
                SSLContext sslContext = SSLContextBuilder.create()
                        .loadTrustMaterial(null, (chain, authType) -> true)
                        .build();
                client = HttpClients.custom()
                        .setSSLContext(sslContext)
                        .setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE)
                        .build();
            } catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            } catch (KeyManagementException e) {
                e.printStackTrace();
            } catch (KeyStoreException e) {
                e.printStackTrace();
            }
//        }
        if (client == null) {
            client = HttpClients.createDefault();
        }
        // 创建一个post对象
        HttpDelete delete = new HttpDelete(url);
        CloseableHttpResponse response = null;
        try {
            // 设置请求的报文头部的编码
            delete.addHeader("Content-Type", "application/json;charset=utf-8");
            if (CollectionUtil.isNotEmpty(headerMap)) {
                for (Map.Entry<String, String> header : headerMap.entrySet()) {
                    delete.addHeader(header.getKey(), header.getValue());
                }
            }
            // 执行post请求
            response = client.execute(delete);
            result = EntityUtils.toString(response.getEntity());
            logger.info("deleteId：{}, 请求参数结果：{}", deleteId, result);
            // 获取响应码
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                result = CommonConstant.HTTP_REQUEST_FAIL_RESULT;
                logger.error("调用接口请求失败,错误码为：" + statusCode);
                delete.abort();
            }
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("调用接口请求失败：" + e.getMessage(), e);
            result = CommonConstant.HTTP_REQUEST_FAIL_RESULT;
            delete.abort();
        } finally {
            if (response != null) {
                try {
                    response.close();
                    delete.abort();
                } catch (IOException e) {
                    e.printStackTrace();
                    logger.error("关闭接口response出错：" + e.getMessage(), e);
                }
            }
            try {
                client.close();
                delete.abort();
            } catch (IOException e) {
                e.printStackTrace();
                logger.error("关闭http接口client出错：" + e.getMessage(), e);
            }
        }
        logger.info("=====================http delete 请求结果=====================");
        logger.info("deleteId：" + deleteId);
        logger.info("请求结果：" + result);
        logger.info("=======================================================");
        return result;
    }

    /**
     * http put请求
     */
    public static String put(String url, String bodyJson, Map<String, String> headerMap, boolean isSkipSsl) {
        String putId = UUID.randomUUID().toString();
        logger.info("=====================http put 请求=====================");
        logger.info("putId：" + putId);
        logger.info("请求地址：" + url);
        logger.info("=======================================================");
        String result = "";
        // 创建一个httpclient对象
        CloseableHttpClient client = null;
//        if (isSkipSsl) {
            // 创建信任所有证书的TrustManager
            TrustManager[] trustAllCerts = new TrustManager[]{
                    new X509TrustManager() {
                        public void checkClientTrusted(X509Certificate[] chain, String authType) {}
                        public void checkServerTrusted(X509Certificate[] chain, String authType) {}
                        public X509Certificate[] getAcceptedIssuers() { return new X509Certificate[0]; }
                    }
            };
            // 初始化SSLContext
            try {
                SSLContext sslContext = SSLContextBuilder.create()
                        .loadTrustMaterial(null, (chain, authType) -> true)
                        .build();
                client = HttpClients.custom()
                        .setSSLContext(sslContext)
                        .setSSLHostnameVerifier(NoopHostnameVerifier.INSTANCE)
                        .build();
            } catch (NoSuchAlgorithmException e) {
                e.printStackTrace();
            } catch (KeyManagementException e) {
                e.printStackTrace();
            } catch (KeyStoreException e) {
                e.printStackTrace();
            }
//        }
        if (client == null) {
            client = HttpClients.createDefault();
        }
        // 创建一个post对象
        HttpPut put = new HttpPut(url);
        CloseableHttpResponse response = null;
        try {
            // 设置请求的内容
            put.setEntity(new StringEntity(bodyJson, "utf-8"));
            // 设置请求的报文头部的编码
            put.addHeader("Content-Type", "application/json;charset=utf-8");
            if (CollectionUtil.isNotEmpty(headerMap)) {
                for (Map.Entry<String, String> header : headerMap.entrySet()) {
                    put.addHeader(header.getKey(), header.getValue());
                }
            }
            // 执行post请求
            response = client.execute(put);
            result = EntityUtils.toString(response.getEntity());
            logger.info("putId：{}, 请求参数结果：{}", putId, result);
            // 获取响应码
            int statusCode = response.getStatusLine().getStatusCode();
            if (statusCode != 200) {
                result = CommonConstant.HTTP_REQUEST_FAIL_RESULT;
                logger.error("调用接口请求失败,错误码为：" + statusCode);
                put.abort();
            }
        } catch (Exception e) {
            e.printStackTrace();
            logger.error("调用接口请求失败：" + e.getMessage(), e);
            result = CommonConstant.HTTP_REQUEST_FAIL_RESULT;
            put.abort();
        } finally {
            if (response != null) {
                try {
                    response.close();
                    put.abort();
                } catch (IOException e) {
                    e.printStackTrace();
                    logger.error("关闭接口response出错：" + e.getMessage(), e);
                }
            }
            try {
                client.close();
                put.abort();
            } catch (IOException e) {
                e.printStackTrace();
                logger.error("关闭http接口client出错：" + e.getMessage(), e);
            }
        }
        logger.info("=====================http put 请求结果=====================");
        logger.info("putId：" + putId);
        logger.info("请求结果：" + result);
        logger.info("=======================================================");
        return result;
    }
}
